<?php
$inscripcion_id = isset($_GET['inscripcion_id']) ? base64_decode($_GET['inscripcion_id']) : null;
if ($inscripcion_id) {
    $inscripcion = InscripcionesData::getById($inscripcion_id);
    $persona = PersonasData::getById($inscripcion->persona_id);
    $pensum = PensumsData::getById($inscripcion->pensum_id);
}
?>

<div class="main-panel">
    <div class="content-wrapper">
        <div class="row">
            <div class="col-lg-12 grid-margin">
                <div class="card">
                    <div class="card-body">
                        <!-- si o si para contenido-->

                        <h4 class="display_1"> <?php echo $pensum->especialidad . ' (' . $pensum->version . ' - ' . $pensum->inst . ')' ?></h4>
                        <hr>


                        <div class="row">
                            <div class="col-md-8 col-md-offset-2">
                                <div class="form-group col-md-12">
                                    <h3>PARTICIPANTE</h3>
                                    <div class=" table-responsive">
                                        <table id="tbParticipante" style="border: 0px solid black; width: 100%; font-size: 14px">
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>
                        <form action="index.php?action=guardarRequisitosTitulacion" role="form" method="post">
                            <div class="row">
                                <div class="col-md-12 col-md-offset-0">
                                    <div class="form-group col-md-9">
                                        <input type="hidden" class="form-control " name="inscripcion_id" id="inscripcion_id" value="<?php echo $inscripcion_id; ?>" />
                                        <h4>Requisitos (<?php echo $pensum->tipo . ' - ' . $pensum->inst ?>)</h4>
                                        <div class=" table-responsive">
                                            <table id="tbRequisitosNOs" class="table table-striped table-bordered table-condensed">
                                                <thead>
                                                    <th>Nº</th>
                                                    <th>REQUISITO</th>
                                                    <th>TENGO</th>
                                                </thead>
                                                <tbody>
                                                    <?php include 'app/controller/actions/titulaciones/a.getRequisitoTitulo.php'; ?>
                                                </tbody>

                                            </table>
                                            <br>
                                            <div class="form-group">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" id="declaration" name="declaration" required>
                                                    <label class="form-check-label" for="declaration">
                                                        Yo, <strong><?php echo $persona->nombre . ' ' . $persona->paterno . ' ' . $persona->materno; ?></strong>, con documento de identidad <strong> <?php echo $persona->carnet; ?></strong>, declaro bajo juramento que la información proporcionada en el presente formulario para mi <?php echo $pensum->tipo == 'DIPLOMADO' ? 'CERTIFICACIÓN' : 'TITULACIÓN' ?> en el programa de <strong><?php echo $pensum->especialidad . ' (' . $pensum->version . ' - ' . $pensum->oferta . '/' . $pensum->gestion . ')' ?> </strong> <strong class="text-danger">es verídica y fidedigna</strong>. Asumo plena responsabilidad por la autenticidad de los datos ingresados y acepto que cualquier falsedad podrá derivar en las sanciones administrativas o legales correspondientes, conforme a la normativa vigente.
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <br>
                                        <div class="form-group">
                                            <?php if ($deposito) { ?>
                                                <button type="submit" name="btnRegistrar" class="btn btn-success">Registrar requisitos</button>
                                            <?php } ?>
                                            <INPUT TYPE="button" class="btn btn-light" VALUE="Cancelar" onClick="history.go(-1);">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- de aqui abajo si o si para contenido-->
                </div>
            </div>
        </div>
    </div>
</div>

</div>
</div>

<script type="application/javascript">
    $(document).ready(function() {
        var personaId = <?php echo $persona->id; ?>;
        $.ajax({
            type: "POST",
            url: "app/controller/actions/personas/a.getParticipante.php",
            data: {
                personaId: personaId
            },
            success: function(response) {
                $('#tbParticipante').html(response).fadeIn();
            }
        });
    });
</script>

<script type="application/javascript">
    $(document).ready(function() {
        $('form').on('submit', function(e) {
            e.preventDefault();
            Swal.fire({
                title: '¿Está seguro?',
                text: "¿Está seguro de que desea registrar los requisitos?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Sí, registrar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    this.submit();                    
                }
            });
        });
    });
</script>