<?php
/* DECLARAMOS EL ARCHIVO PRINCIPAL QUE CONTIENE LA CLASE MPDF 
   * PARA CREAR EL DOCUMENTO PDF */
require_once('./app/vendor/autoload.php');
require 'app/codigoQR/PHPQRCode.class.php';
include '../../Database.php';
$base = new Database();
$con = $base->connect();
use Luecano\NumeroALetras\NumeroALetras;
$conversor = new NumeroALetras();


$idt= base64_decode($_GET['idt']);
$idn= base64_decode($_GET['idn']);
$eut= base64_decode($_GET['eut']);

$depositoObject=DepositosData::getById($idt);
$idPer=$depositoObject->persona_id;
$idTram=$depositoObject->tramite_id;
$precioUnitario=$depositoObject->monto;
$numeroComprobante=$depositoObject->nro_deposito;
$fechaTransaccion=date('d/m/Y',strtotime($depositoObject->updated_at));

$tramiteObject=TramitesData::getById($idTram);
$codigoTramite=$tramiteObject->codigo_portal_unico;
$unidadMedida=$tramiteObject->grupo;
$descripcion=$tramiteObject->descripcion;
//$precioUnitario=$tramiteObject->monto;
$montoValor=$conversor->toWords($precioUnitario, 0);
$montoLiteral=ucfirst(strtolower($montoValor));

$personaObject=PersonasData::getById($idPer);
$nombrePart=$personaObject->paterno.'  '.$personaObject->materno.' '.$personaObject->nombre;
$ci=$personaObject->carnet;

$sql = "select pensums.gestion, pensums.oferta, pensums.especialidad, pensums.version, pensums.modalidad, modulos.codigo, modulos.modulo from notas join grupos on grupos.id = notas.grupo_id join modulos on modulos.id = grupos.modulo_id join pensums on pensums.id = modulos.pensum_id where notas.id = $idn";

$query=$con->prepare($sql);

$result=$query->execute();

if ($result){
    $moduloObject = $query->fetch(PDO::FETCH_OBJ);
    $descripcion = '<b>' . $moduloObject->codigo . '</b>|' . $moduloObject->modulo . ' <br>(' . $moduloObject->especialidad . ' [' . $moduloObject->version . ', ' . $moduloObject->oferta . '/' . $moduloObject->gestion . ']' . ')';
}

date_default_timezone_set('America/La_Paz');
$fecha=date("Y-m-d");

$fechaActual = date("d/m/Y", strtotime($fecha));

$config = array(
        'ecc' => 'M',    // L-smallest, M, Q, H-best
        'size' => 10,    // 1-50
        'dest_file' => 'app/codigoQR/imagesqr/qrup.png',
        'quality' => 90,
        'logo' => 'app/codigoQR/LOGUP.jpeg',
        'logo_size' => 100,
        'logo_outline_size' => 0,
        'logo_outline_color' => '#FFFF00',
        'logo_radius' => 50,
        'logo_opacity' => 100,
);

// Crea una clase de código QR
$oPHPQRCode = new PHPQRCode();

// establecer configuración
$oPHPQRCode->set_config($config);
  
// DESDE AQUI PARA COMPROBANTE DE PAGO EN LÍNEA
     # --- \\ CABECERA DEL DOCUMENTO // --- #

$cuerpo='
<table class="header">
    <tr>
        <td style="width: 30%;"  align="left">
        </td>
            
        <td style="width: 25%;" align="center">
            <img src="app/public/img/logoUPAZUL.png" height="60">
            <p> &nbsp;</p>
            <p style="font-size:8pt;"><b> 
                UNIVERSIDAD PEDAGÓGICA </b></p>
                <p style="font-size:6pt;"> 
                CALLE NICOLÁS ORTIZ NRO. 198 ESQ. AZURDUY </p>
                <p style="font-size:6pt;"> 
                Teléfono: 46453515 </p>
                <p style="font-size:6pt;"> 
                SUCRE, BOLIVIA </p>
                <p> &nbsp;</p>
            <p style="font-size:14pt;"> 
                REPORTE</p>
                <p> &nbsp;</p>
            <p style="font-size:12pt;"><b> 
                REGISTRO DE DEPÓSITO BANCARIO (BOUCHER) </b></p>
            <p style="font-size:6pt;"><b> 
                (Expresado en Bs.) </b></p>
                <p> &nbsp;</p>
        </td>

        <td style="width: 25%;" align="right">
        </td>
    </tr>
</table>

<table border="0" class="cuerpo" style="width: 100%; ">
    <tr>
       <td align="right" colspan="2"  style="font-size:pt; padding: 2px; border: 0px solid #555; font-weight: bold;">Fecha Registro:
       </td>
       <td align="left" colspan="2"  style="font-size:pt; padding: 2px; border: 0px solid #555;">'.$fechaTransaccion.'
       </td>
       <td align="right" colspan="2"  style="font-size:pt; padding: 2px; border: 0px solid #555;font-weight: bold;">CI:
       </td>
       <td align="left" colspan="2"  style="font-size:pt; padding: 2px; border: 0px solid #555;">'.$ci.'
       </td>
    </tr>

    <tr>
       <td align="right" colspan="2"  style="font-size:pt; padding: 2px; border: 0px solid #555; font-weight: bold;">Nombre completo:
       </td>
       <td align="left" colspan="2"  style="font-size:pt; padding: 2px; border: 0px solid #555;">'.$nombrePart.'
       </td>
       <td align="right" colspan="2"  style="font-size:pt; padding: 2px; border: 0px solid #555;font-weight: bold;">N° Depósito:
       </td>
       <td align="left" colspan="2"  style="font-size:pt; padding: 2px; border: 0px solid #555; color:red;font-weight: bold;">'.$numeroComprobante.'
       </td>
    </tr>
</table>


';



 # --- \\ CUERPO DEL DOCUMENTO // --- #
   
$cuerpo.='
<table border="1" class="cuerpo" style="width: 100%; ">
    <tr>
        <td align="center" bgcolor="#DBDBDB" style=" font-size:8.5pt; padding: 2px; border: 1px solid #555; width: 15%; font-weight: bold;">CÓDIGO:</td>
        <td align="center" bgcolor="#DBDBDB" style="font-size:8.5pt; padding: 2px; border: 1px solid #555; width: 15%; font-weight: bold;">CANTIDAD</td>      
        <td align="center" bgcolor="#DBDBDB" style="font-size:8.5pt; padding: 2px; border: 1px solid #555; width: 15%; font-weight: bold;">DESCRIPCION</td>
        <td align="center" bgcolor="#DBDBDB" style="font-size:8.5pt; padding: 2px; border: 1px solid #555; width: 15%; font-weight: bold;">PRECIO UNITARIO</td>
        <td align="center" bgcolor="#DBDBDB" style="font-size:8.5pt; padding: 2px; border: 1px solid #555; width: 15%; font-weight: bold;">SUBTOTAL</td>
    </tr>

    <tr>
        <td align="center" style="font-size:7pt; padding: 2px; border: 1px solid #555;">'.$codigoTramite.'</td>
        <td align="center" style="font-size:7pt; padding: 2px; border: 1px solid #555;"> 1 </td>
        <td align="left" style="font-size:7pt; padding: 2px; border: 1px solid #555;">'.$descripcion.'</td>
        <td align="center" style="font-size:7pt; padding: 2px; border: 1px solid #555;">'.$precioUnitario.'.00</td>
        <td align="center" style="font-size:7pt; padding: 2px; border: 1px solid #555;">'.$precioUnitario.'.00</td>
    </tr>
    <tr>
        <td align="right" colspan="4"  style="font-size:7pt; padding: 2px; border: 0px solid #555;font-weight: bold;">SUBTOTAL Bs.</td>
        <td align="center" style="font-size:7pt; padding: 2px; border: 1px solid #555;">'.$precioUnitario.':00</td>
    </tr>
    <tr>
        <td align="right" colspan="4"  style="font-size:7pt; padding: 2px; border: 0px solid #555; font-weight: bold;">DESCUENTO Bs.</td>
        <td align="center" style="font-size:7pt; padding: 2px; border: 1px solid #555;"> 0.00 </td>
    </tr>
    <tr>
        
        <td align="left" colspan="2"  style="font-size:pt; padding: 2px; border: 0px solid #555; font-weight: bold;">Son: '.$montoLiteral.'   00/100 Bolivianos.</td>
        <td align="right" colspan="2"  style="font-size:7pt; padding: 2px; border: 0px solid #555; font-weight: bold;">TOTAL Bs.</td>
        <td align="center" style="font-size:7pt; padding: 2px; border: 1px solid #555;">'.$precioUnitario.'.00</td>
    </tr>

</table>
<br />
<table border="0" class="cuerpo" style="width: 100%; ">
    <tr>
        <td style="align center border: 0px solid #555;">
            <p style="font-size:7pt;"> 
            "Este documento es la constancia de haber registrado un depósito bancario para un programa de postgrado" </p>
        </td>
    </tr>
    <tr>
        <td style="align center border: 0px solid #555;"><br>            
            <p><strong>NO OLVIDE PRESENTAR SU DEPÓSITO MÁS TRES FOTOCOPIAS SIMPLES EN SU SEDE AUTORIZADA <br>EVITE OBSERVACIONES A FUTURO</strong></p>
        </td>
    </tr>
    <tr>
        <td style="align center border: 0px solid #555;"><br>            
            <p><small>Imprima este documento en el reverso de las fotocopias simples de su depósito</small></p>
        </td>
    </tr>
</table>
';


    $mpdf= new \Mpdf\Mpdf(['mode' => '','format' => 'Letter','margin_left' => 10,'margin_right' => 10,'margin_top' => 15,'margin_bottom' => 1]);

    $mpdf->SetWatermarkImage('app/public/img/linea_grafica.jpg');
    $mpdf->showWatermarkImage = true;

       // Establecemos la hoja de estilo en cascada a utilizar en el documento
    $stylesheet = file_get_contents('app/vendor/mpdf/css/Print-PDF-COMPROBANTE.css');
  

    $mpdf->WriteHTML($stylesheet,1);
    $mpdf->WriteHTML($cuerpo,2);

    $mpdf->Output('Comprobante:'.$numeroComprobante.'','I');
     exit;
?>