<?php
/* DECLARAMOS EL ARCHIVO PRINCIPAL QUE CONTIENE LA CLASE MPDF 
   * PARA CREAR EL DOCUMENTO PDF */
require_once('./app/vendor/autoload.php');
require 'app/codigoQR/PHPQRCode.class.php';
$base = new Database();
$con = $base->connect();

$inscripcion_id = base64_decode($_GET['iId']);
$verificar = RequisitosTitulacionData::getByIdInscripcion($inscripcion_id);

if ($verificar) {

    $config = array(
        'ecc' => 'M',    // L-smallest, M, Q, H-best
        'size' => 10,    // 1-50
        'dest_file' => 'app/codigoQR/imagesqr/qrup.png',
        'quality' => 90,
        'logo' => 'app/codigoQR/LOGUP.jpeg',
        'logo_size' => 100,
        'logo_outline_size' => 0,
        'logo_outline_color' => '#FFFF00',
        'logo_radius' => 50,
        'logo_opacity' => 100,
    );

    // Crea una clase de código QR
    $oPHPQRCode = new PHPQRCode();

    // establecer configuración
    $oPHPQRCode->set_config($config);

    $inscripcion = InscripcionesData::getById($inscripcion_id);
    $persona = PersonasData::getById($inscripcion->persona_id);
    $pensum = PensumsData::getById($inscripcion->pensum_id);
    $deposito = DepositosData::getByIdperIdpenConcep($inscripcion->persona_id, $inscripcion->pensum_id, 'TIT');
    $requisitos_ids = $verificar->requisitos;
    $sql = "
        select requisito
        from requisitos
        where id in ($requisitos_ids)
        order by id
    ";
    $query = $con->prepare($sql);
    $result = $query->execute();

    if ($result) {
        $requisitos = $query->fetchAll(PDO::FETCH_OBJ);
        $i = 0;
        foreach ($requisitos as $requisito) {
            print_r($requisito->requisito);
        }
    }

    $tipo_titulacion = $pensum->tipo == 'DIPLOMADO' ? 'CERTIFICACIÓN' : 'TITULACIÓN';

    $cuerpo = '
    <table class="header">
        <tr>
            <td style="width: 30%;"  align="left">
            </td>
                
            <td style="width: 25%;" align="center">
                <img src="app/public/img/logoUPAZUL.png" height="60">
                <p> &nbsp;</p>
                <p style="font-size:8pt;"><b> 
                    UNIVERSIDAD PEDAGÓGICA </b></p>
                    <p style="font-size:6pt;"> 
                    CALLE NICOLÁS ORTIZ NRO. 198 ESQ. AZURDUY </p>
                    <p style="font-size:6pt;"> 
                    Teléfono: 46453515 </p>
                    <p style="font-size:6pt;"> 
                    SUCRE, BOLIVIA </p>
                    <p> &nbsp;</p>
                <p style="font-size:12pt;"> 
                    FICHA DE HABILITACIÓN</p>
                <p style="font-size:10pt;"><b> 
                    PROCESO DE ' . $tipo_titulacion . ' </b></p>
                <p style="font-size:6pt;"><b> 
                    (Declaración Jurada) </b></p>
                    <p> &nbsp;</p>
            </td>

            <td style="width: 25%;" align="right">
            </td>
        </tr>
    </table>

    <table class="cuerpo" style="width: 100%;">
        <tr>
            <th align="right" colspan="2" style="border: 0px; color: red; font-size: 10pt;">Nro. ' . $inscripcion_id . '</th>
        </tr>
        <tr>
            <th align="left" style="width:20%; padding: 6px; border: 1px solid #555; background-color: #00B0F0;">PROGRAMA:
            </th>
            <td align="left" style="padding: 6px; border: 1px solid #555;">' . $pensum->especialidad . ' (' . $pensum->version . ' - ' . $pensum->oferta . '/' . $pensum->gestion . ')' . '
            </td>
        </tr>
        <tr>
            <th align="left" style="width:20%; padding: 6px; border: 1px solid #555; background-color: #00B0F0;">CARNET:
            </th>
            <td align="left" style="padding: 6px; border: 1px solid #555;">' . $persona->carnet . '
            </td>
        </tr>
        <tr>
            <th align="left" style="width:20%; padding: 6px; border: 1px solid #555; background-color: #00B0F0;">PARTICIPANTE:
            </th>
            <td align="left" style="padding: 6px; border: 1px solid #555;">' . $persona->nombre . ' ' . $persona->paterno . ' ' . $persona->materno . '
            </td>
        </tr>        
        <tr>
            <th align="left" style="width:20%; padding: 6px; border: 1px solid #555; background-color: #00B0F0;">CELULAR:
            </th>
            <td align="left" style="padding: 6px; border: 1px solid #555;">' . $persona->celular . '
            </td>
        </tr>        
    </table><br>';

    $cuerpo .= '
    <table class="cuerpo" style="width: 100%;">
        <tr>
            <th align="center" colspan="3" style="padding: 6px; border: 1px solid #555; background-color: #00B0F0;">REQUISITO TITULACIÓN
            </th>               
        </tr>
        <tr>
            <td align="center" colspan="3" style="border: 0px;">&nbsp;</td>
        </tr>        
        <thead>
            <tr>
                <th style="width: 8%;">Nº</th>
                <th>REQUISITO</th>
                <th style="width: 18%;">ESTADO</th>
            </tr>
        </thead>
        <tbody>
    ';

    $i = 0;
    foreach ($requisitos as $requisito) {
        $i++;
        $cuerpo .= '
            <tr>
                <th style="padding: 6px; border: 1px solid #555; background-color: #00B0F0;">' . $i . '</th>
                <th align="left" style="padding: 6px; border: 1px solid #555; background-color: #00B0F0;">' . $requisito->requisito . '</th>
                <td>Cumplo</td>
            </tr>
        ';
    }

    $i++;
    $cuerpo .= '
        <tr>
            <th style="padding: 6px; border: 1px solid #555; background-color: #00B0F0;">' . $i . '</th>
            <th align="left" style="padding: 6px; border: 1px solid #555; background-color: #00B0F0;">NÚMERO DEPÓSITO</th>
            <td>' . $deposito->nro_deposito . '</td>
        </tr>
    ';

    $i++;
    $cuerpo .= '
        <tr>
            <th style="padding: 6px; border: 1px solid #555; background-color: #00B0F0;">' . $i . '</th>
            <th align="left" style="padding: 6px; border: 1px solid #555; background-color: #00B0F0;">FECHA DEPÓSITO</th>
            <td>' . date('d/m/Y', strtotime($deposito->fecha_deposito)) . '</td>
        </tr>
    ';

    $i++;
    $cuerpo .= '
        <tr>
            <th style="padding: 6px; border: 1px solid #555; background-color: #00B0F0;">' . $i . '</th>
            <th align="left" style="padding: 6px; border: 1px solid #555; background-color: #00B0F0;">MONTO DEPÓSITO</th>
            <td>' . $deposito->monto . '</td>
        </tr>
    ';

    $cuerpo .= '
        </tbody> 
        <tfooter>
            <tr>
                <td align="justify" colspan="3" style="border: 0px;"><br>
                    Yo, <strong>' . $persona->nombre . ' ' . $persona->paterno . ' ' . $persona->materno . '</strong>, con documento de identidad ' . ' <strong> ' . $persona->carnet . '</strong>, declaro bajo juramento que la información proporcionada en el presente formulario para mi ' . $tipo_titulacion . ' en el programa de <strong> ' . $pensum->especialidad . ' (' . $pensum->version . ' - ' . $pensum->oferta . '/' . $pensum->gestion . ')' .'</strong>, <strong class="text-danger">es verídica y fidedigna</strong>. Asumo plena responsabilidad por la autenticidad de los datos ingresados y acepto que cualquier falsedad podrá derivar en las sanciones administrativas o legales correspondientes, conforme a la normativa vigente.
                </td>
            </tr>
            <tr>
                <td align="center" colspan="3" style="border: 0px;"><br><br><br><br>
                    _____________________________________________<br>
                    <strong>' . $persona->nombre . ' ' . $persona->paterno . ' ' . $persona->materno . '</strong><br>
                    PARTICIPANTE                    
                </td>
            </tr>
        </tfooter>
    </table>
    ';
    
    $mpdf = new \Mpdf\Mpdf(['mode' => '', 'format' => 'Letter', 'margin_left' => 15, 'margin_right' => 15, 'margin_top' => 10, 'margin_bottom' => 1]);

    $mpdf->SetWatermarkImage('app/public/img/linea_grafica.jpg');
    $mpdf->showWatermarkImage = true;

    // Establecemos la hoja de estilo en cascada a utilizar en el documento
    $stylesheet = file_get_contents('app/vendor/mpdf/css/Print-PDF-COMPROBANTE.css');

    $mpdf->WriteHTML($stylesheet, 1);
    $mpdf->WriteHTML($cuerpo, 2);

    $mpdf->Output('requisito_' . $inscripcion_id . '', 'I');
    exit;

} else {
    echo "<script type='application/javascript'>
        Swal.fire({
            icon: 'info',
            title: 'Requisitos no registrados',
            text: 'Los requisitos de titulación para este programa no han sido registrados.',
            confirmButtonText: 'Entiendo'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = 'index.php?action=consultaDeudas';
            }
        });
    </script>";
    exit;
}
