<div class= "container-scroller">
  <div class="container-fluid page-body-wrapper full-page-wrapper auth-page">
    <div class="content-wrapper d-flex align-items-center auth auth-bg-1 theme-one">
      <div class="row w-100">
        <div class="col-lg-6 mx-auto">
          <div class="auto-form-wrapper">
            <div class="login-box">
              <div class="login-logo" style="text-align:center; color:#307fff; font-size: 20px">
                <img src="app/public/img/logoUPAZUL.png" class="img-fluid" alt="logo" style="width: 20%">
              </div>
              <!-- /.login-logo -->
              <div class="login-box-body">
                <center><h4 class="login-box-msg">Registro participantes nuevos</h4></center>

                <form method="POST" action="index.php?action=addNuevaPersona" enctype="multipart/form-data">
                  <div class="form-row">
                    <div class="col-md-4 mb-3">
                      <label for="ci">Nro. de C.I.: (<small class="text-danger">Sin expedido</small>)</label>
                      <input type="text" class="form-control mayusculas" id="ci" name="ci" placeholder="Ej. 1390718 ó 1390718-1F" required>
                    </div>
                    <div class="col-md-4 mb-3">
                      <label for="rda">Nro. de RDA:</label>
                      <input type="text" onkeypress="return justNumbers(event);" class="form-control" id="rda" name="rda"required>
                    </div>
                    <div class="col-md-4 mb-3">
                      <label for="fec_nac">Fecha de Nacimiento:</label>
                      <input type="date" format="dd/mm/aaaa" class="form-control" id="fec_nac" name="fec_nac"  required>
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="col-md-4 mb-3">
                      <label for="validationServer01">Nombre(s):</label>
                      <input type="text" class="form-control mayusculas" id="nombres" name="nombres" required>
                    </div>
                    <div class="col-md-4 mb-3">
                      <label for="validationServer02">Primer apellido(s):</label>
                      <input type="text" class="form-control mayusculas" id="paterno" name="paterno"  required>
                    </div>
                    <div class="col-md-4 mb-3">
                      <label for="validationServer02">Segundo apellido(s):</label>
                      <input type="text" class="form-control mayusculas" id="materno" name="materno">
                    </div>
                  </div>

                  

                  <div class="form-row">  
                    <div class="col-md-6 mb-3">
                      <label for="validationServer03">Correo electrónico:</label>
                      <input type="email" class="form-control" id="email" name="email"placeholder="example@mail.com"  required>
                    </div>
                    <div class="col-md-6 mb-3">
                      <label for="validationServer03">Nro. de celular:</label>
                      <input type="text" onkeypress="return justNumbers(event);" class="form-control " name="celular" id="celular" minlength="8" maxlength="8" required>
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="col-md-12 mb-3">
                      <label><b>Subir documento RDA (Solo se admite el documento en PDF descargado de la UGPSEP menor a 1Mb)</b></label>
                      <input type="file" accept=".pdf" class="form-control-file" id="file_rda" name="file_rda" required>
                    </div>
                  </div>

                  <div class="form-group">
                    <div class="form-check">
                      <input class="form-check-input is-invalid" type="checkbox" value="" name="invalidCheck3"id="invalidCheck3" required>
                      <label class="form-check-label" for="invalidCheck3">
                        <b>Revisé todos mis datos.</b>
                      </label>
                      <div  id="invalidCheck3Feedback" class="invalid-feedback">
                        Marque la casilla antes de enviar
                      </div>
                    </div>
                  </div>
                  <center><button class="btn btn-primary" type="submit">Registrar datos</button></center>
                 
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>


<script> 
 $(document).ready(function() {  
  document.getElementById('ci').focus();
  document.getElementById("ci").onblur = function() {buscar()};
  document.getElementById("fec_nac").onblur = function() {ValidarFecha()};

function buscar() {
  var ci=document.getElementById("ci").value.trim();
  if(ci!=''){
        var modci=ci;
        $.ajax({
          type: "GET",
          url: "app/controller/actions/personas/a.getValidarNuevaPersona.php",
          data: {modci:modci},
          success: function(data){
            console.log(data);
            if(data!=''){
              document.getElementById('ci').value ='';
              document.getElementById('rda').value ='';
              Swal.fire({
                position: 'top-center',
                icon: 'warning',
                title: 'El num de ci ya existe '+data,
                showConfirmButton: false,
                 timer: 2500,
              });
            }
          }
        });
  }else {
        document.getElementById('ci').focus();
        Swal.fire({
                position: 'top-center',
                icon: 'warning',
                title: 'El campo ci es obligatorio ',
                showConfirmButton: false,
                 timer: 2500,
              });
  }
}

function ValidarFecha(){
    var nacimiento = new Date(document.getElementById("fec_nac").value); 
    var hoy = new Date();
    var edad = hoy.getFullYear() - nacimiento.getFullYear();
    if(edad<17 || edad>1900){
      document.getElementById('fec_nac').value = ''; 
      Swal.fire({
        position: 'top-center',
        icon: 'warning',
        title: 'ERROR EN FECHA DE NACIMIENTO, VERIFIQUE E INTENTE NUEVAMENTE',
        showConfirmButton: false,
        timer: 2500,
      });
    }
  }
}
);
</script>


<!-- validamos el tamaño del archivo dertificado-->
<script type="text/javascript">
       $('#file_rda').bind('change', function() {
        const MAXIMO_TAMANIO_BYTES = 1000000; // 1MB = 1 millón de bytes
        var archivo = this.files[0];

        if( archivo.size > MAXIMO_TAMANIO_BYTES ){
          Swal.fire({
                position: 'top-center',
                icon: 'warning',
                title: 'El tamaño del archivo no debe ser mayor a 1 Mb',
                showConfirmButton: false,
                 timer: 2500,
              })
           document.getElementById('file_rda').value =''; 
        }
       });
</script>