<?php
function writeJsonLog(array $data, string $logFile = 'application.log'): bool
{
    // 1. Agregar metadatos de tiempo (opcional, pero útil para logs)
    $logEntry = [
        'timestamp' => (new DateTime())->format('Y-m-d H:i:s.v'),
        'data' => $data
    ];

    // 2. Convertir el array a una cadena JSON
    // JSON_UNESCAPED_UNICODE: Para que los caracteres como 'ñ' o 'á' se muestren correctamente.
    // JSON_PRETTY_PRINT: Para que el JSON se vea formateado (con saltos de línea e indentación).
    $jsonString = json_encode(
        $logEntry,
        JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT
    );

    // 3. Verificar si la codificación JSON fue exitosa
    if ($jsonString === false) {
        // En un entorno de producción, puedes loggear este error de otra forma
        error_log("Error al codificar a JSON: " . json_last_error_msg());
        return false;
    }

    // 4. Asegurar que haya una nueva línea después del JSON
    // Se añade un separador claro.
    $logContent = $jsonString . "\n---\n";

    // 5. Escribir el contenido al archivo
    // FILE_APPEND: Agrega el contenido al final del archivo.
    // LOCK_EX: Bloquea el archivo mientras escribe para prevenir corrupción por concurrencia.
    $result = file_put_contents($logFile, $logContent, FILE_APPEND | LOCK_EX);

    return $result !== false;
}
$successLog = [
    'level' => 'SUCCESS',
    'module' => 'API_Users',
    'action' => 'User creation',
    'message' => 'El nuevo usuario "Maria_R" ha sido registrado correctamente.',
    'user_id' => 258,
    'execution_time_ms' => 45
];

$warningLog = [
    'level' => 'WARNING',
    'module' => 'Payment_Gateway',
    'action' => 'Transaction lookup',
    'message' => 'Transacción con ID 8901 no encontrada en la caché; consultando base de datos.',
    'transaction_id' => 8901,
    'source' => 'Cache'
];
writeJsonLog($successLog);
writeJsonLog($warningLog);