<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Origin,Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    include 'controller/Database.php';
    $base = new Database();
    $con = $base->connect();
    $con1 = $base->connect();
    $con2 = $base->connect();
    $con3 = $base->connect();
    require 'model/NotificacionesData.php';
    require 'model/TransaccionesData.php';
    require 'model/DepositosData.php';

    $datosRecibidos = file_get_contents("php://input");
    $notificacionppe = json_decode($datosRecibidos);
    date_default_timezone_set('America/La_Paz');
    $fechaActual = date("Y-m-d H:i:s");

    //var_dump($notificacionppe); exit();
    //
    $finalizado = $notificacionppe->finalizado;
    
    
    if ($finalizado) {
        $codigoSeguimiento = $notificacionppe->codigoSeguimiento;
        $mensaje = $notificacionppe->mensaje;
        $fuente = $notificacionppe->fuente;
        $estado = $notificacionppe->estado;
        $detalleNotificacion = $datosRecibidos;

        $datosNotificacion = new NotificacionesData();
        $datosNotificacion->finalizado = $finalizado;
        $datosNotificacion->codigo_seguimiento = $codigoSeguimiento;
        $datosNotificacion->mensaje = $mensaje;
        $datosNotificacion->fuente = $fuente;
        $datosNotificacion->estado = $estado;
        $datosNotificacion->detalle = $detalleNotificacion;
        $datosNotificacion->created_at = $fechaActual;
        $datosNotificacion->updated_at = $fechaActual;



        if ($datosNotificacion->create()) {
            $sql = "UPDATE transacciones SET estado=?,updated_at=? where codigo_transaccion=?";
            $query = $con->prepare($sql);
            $result = $query->execute(array('PROCESADO', $fechaActual, $codigoSeguimiento));
        }

        if ($estado == 'PROCESADO') {
            $sql1 = "SELECT * FROM transacciones
              WHERE codigo_transaccion='$codigoSeguimiento'
            ";
            $query1 = $con1->prepare($sql1);
            $result1 = $query1->execute();

            // Extraer nro_deposito desde el JSON
            $detalleArray = json_decode($datosRecibidos, true);
            $datosMetodoPagoStr = $detalleArray['detalle']['datosMetodoPago'];
            $datosMetodoPago = json_decode($datosMetodoPagoStr, true);
            
            $nro_deposito = $datosMetodoPago['transacciones'][0];

            while ($res = $query1->fetch(PDO::FETCH_OBJ)) {
                $idTramite = $res->tramite_id;
                $idNota = $res->nota_id;
                $pensum_id = $res->codigo;
                $persona_id = $res->persona_id;
                //$nro_deposito = $res->codigo_transaccion;
                $fechaDep = $res->updated_at;
                $fecha_deposito = date('Y-m-d', strtotime($fechaDep));
                $monto = $res->monto_total;
                $concepto = $res->concepto;
                $confirmado = false;
                $user_id_reg = $res->persona_id;
                $user_id_cfr = $res->persona_id;


                $depositos = new DepositosData();
                $depositos->pensum_id = $pensum_id;
                $depositos->persona_id = $persona_id;
                $depositos->nro_deposito = $nro_deposito;
                $depositos->fecha_deposito = $fecha_deposito;
                $depositos->monto = $monto;
                $depositos->concepto = $concepto;
                $depositos->confirmado = 0;
                $depositos->user_id_reg = $persona_id;
                $depositos->user_id_cfr = $persona_id;
                $depositos->created_at = $fechaActual;
                $depositos->updated_at = $fechaActual;
                $depositos->tramite_id = $idTramite;
                $depositos->create();

                $sql3 = "SELECT * FROM depositos
                    WHERE nro_deposito='$nro_deposito'
                ";
                $query3 = $con3->prepare($sql3);
                $result3 = $query3->execute();
                while ($res3 = $query3->fetch(PDO::FETCH_OBJ)) {
                    $deposito_id = $res3->id;
                    if ($concepto == 'PFO') {
                        $sql2 = "UPDATE notas SET modulo_pagado=?,updated_at=? where id=?";
                        $query2 = $con2->prepare($sql2);
                        $result2 = $query2->execute(array($deposito_id, $fechaActual, $idNota));
                    } else if ($concepto == 'DSI') {
                        $sql2 = "UPDATE notas SET seg_inst_pagado=?,updated_at=? where id=?";
                        $query2 = $con2->prepare($sql2);
                        $result2 = $query2->execute(array($deposito_id, $fechaActual, $idNota));
                    }
                }

// ////////// Actualizar usuario suspendido en Moodle //////////

                $idPersona = $persona_id;
                $idPensum = $pensum_id;
                $montoDeposito = $monto;
                $arancel = $monto;
                $sqlSum = "SELECT SUM(monto) as total_depositado FROM DEPOSITOS WHERE persona_id = :persona_id AND pensum_id = :pensum_id AND concepto = 'PFO'";
                $querySum = $con->prepare($sqlSum);
                $querySum->bindParam(':persona_id', $idPersona, PDO::PARAM_INT);
                $querySum->bindParam(':pensum_id', $idPensum, PDO::PARAM_INT);
                $querySum->execute();
                $resultSum = $querySum->fetch(PDO::FETCH_OBJ);

                $totalDepositado = $resultSum->total_depositado + $montoDeposito;

                // Recuperar un registro de la tabla pensums con el idPensum
                $sqlPensum = "SELECT * FROM pensums WHERE id = :id";
                $queryPensum = $con->prepare($sqlPensum);
                $queryPensum->bindParam(':id', $idPensum, PDO::PARAM_INT);
                $queryPensum->execute();
                $pensum = $queryPensum->fetch(PDO::FETCH_OBJ);

                // Obtener información adicional sobre los módulos y pensums
                $sqlInfo = "SELECT count(*) as modulos_pagables
                FROM notas
                JOIN grupos ON grupos.id = notas.grupo_id
                JOIN modulos ON modulos.id = grupos.modulo_id
                JOIN pensums ON pensums.id = modulos.pensum_id
                WHERE notas.persona_id = :persona_id
                AND pensums.id = :pensum_id";
                if ($pensum->tipo === 'MAESTRÍA') {
                    $sqlInfo .= " AND modulos.correlativo NOT IN (5, 10, 15, 20)";
                }
                $queryInfo = $con->prepare($sqlInfo);
                $queryInfo->bindParam(':persona_id', $idPersona, PDO::PARAM_INT);
                $queryInfo->bindParam(':pensum_id', $idPensum, PDO::PARAM_INT);
                $queryInfo->execute();
                $infoResult = $queryInfo->fetch(PDO::FETCH_OBJ);

                // Determinar el monto total a pagar
                $totalPagar = $infoResult->modulos_pagables * $arancel;

                // Verificar si el monto total depositado es igual o mayor al monto total a pagar
                if ($totalDepositado >= $totalPagar) {

                 //   $moodleKeys = [
                   //     'MAESTRÍA' => 'maestrias',
                      //  'DOCTORADO' => 'doctorados',
                       // 'DIPLOMADO' => 'diplomadossep',
                      //  'ESPECIALIDAD' => 'especialidades'
                   // ];

                  //  $moodleKey = $moodleKeys[$pensum->tipo] ?? null;
                    
              
                    
                    
                    
                    
                        $moodleKey = null;
                    
                    if ($pensum->tipo === 'MAESTRÍA') {
                        $moodleKey = 'maestrias';
                    }
                    
                    if ($pensum->tipo === 'DOCTORADO') {
                        $moodleKey = 'doctorados';
                    }
                    
                    if ($pensum->tipo === 'ESPECIALIDAD') {
                        $moodleKey = 'especialidades';
                    }
                    
                    if ($pensum->tipo === 'DIPLOMADO') {
                    
                        // DIPLOMADOS IA
                        $diplomadosIA = [594,595,596,597,598,599,600,601,602];
                    
                        // DIPLOMADO TIC
                        $diplomadosTIC = [609];
                    
                        // DIPLOMADOS SEP
                        $diplomadosSEP = [603,604,605,606,607,608];
                    
                        if (in_array($pensum->id, $diplomadosIA)) {
                            $moodleKey = 'diplomadosia';
                        } elseif (in_array($pensum->id, $diplomadosTIC)) {
                            $moodleKey = 'diplomadostic';
                        } elseif (in_array($pensum->id, $diplomadosSEP)) {
                            $moodleKey = 'diplomadossep';
                        }
                    }
    
        
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    

                    if ($moodleKey) {

                        // Obtener el ID de usuario en Moodle
                        $sqlNota = "SELECT * FROM notas WHERE id = :id";
                        $queryNota = $con->prepare($sqlNota);
                        $queryNota->bindParam(':id', $idNota, PDO::PARAM_INT);
                        $queryNota->execute();
                        $notasData = $queryNota->fetch(PDO::FETCH_OBJ);

                        if ($notasData) {
                            $moodleUserId = $notasData->moodle_user_id;
                            $suspended = 0;

                            // Actualizar el estado de suspensión del usuario en Moodle
                            require_once __DIR__ . '/model/MoodleUser.php';

                            $affectedRows = MoodleUser::updateSuspendedStatus($moodleKey, $moodleUserId, $suspended);

                            $moodleMessage = '';

                            if ($affectedRows) {
                                $moodleMessage = ' Ahora ya puede realizar sus actividades en su curso con normalidad.';
                            }
                        }
                    }
                }

// ////////// Fin Actualizar usuario suspendido en Moodle //////////
            }
        }

        $json = '{"status": "201", 
            "message":"Notificacion exitosa"
            }';
        echo json_encode($json);
    }
}
