<?php
// ///////// Actualización de estado de suspensión en Moodle /////////

// Recuperar un registro de la tabla pensums con el idPensum
$sqlPensum = "SELECT * FROM pensums WHERE id = :id";
$queryPensum = $con->prepare($sqlPensum);
$queryPensum->bindParam(':id', $idPensum, PDO::PARAM_INT);
$queryPensum->execute();
$pensum = $queryPensum->fetch(PDO::FETCH_OBJ);

// Obtener información adicional sobre los módulos y pensums
$sqlInfo = "SELECT count(*) as modulos_pagables
                FROM notas
                JOIN grupos ON grupos.id = notas.grupo_id
                JOIN modulos ON modulos.id = grupos.modulo_id
                JOIN pensums ON pensums.id = modulos.pensum_id
                WHERE notas.persona_id = :persona_id
                AND pensums.id = :pensum_id";
if ($pensum->tipo === 'MAESTRÍA') {
    $sqlInfo .= " AND modulos.correlativo NOT IN (5, 10, 15, 20)";
}
$queryInfo = $con->prepare($sqlInfo);
$queryInfo->bindParam(':persona_id', $idPersona, PDO::PARAM_INT);
$queryInfo->bindParam(':pensum_id', $idPensum, PDO::PARAM_INT);
$queryInfo->execute();
$infoResult = $queryInfo->fetch(PDO::FETCH_OBJ);

// Determinar el monto total a pagar
$totalPagar = $infoResult->modulos_pagables * $arancel;

// Verificar si el monto total depositado es igual o mayor al monto total a pagar
if ($totalDepositado >= $totalPagar) {

   // $moodleKeys = [
     //   'MAESTRÍA' => 'maestrias',
      //  'DOCTORADO' => 'doctorados',
      //  'DIPLOMADO' => 'diplomadossep',
     //   'ESPECIALIDAD' => 'especialidades'
  //  ];

  //  $moodleKey = $moodleKeys[$pensum->tipo] ?? null;
    
    
    
    
    $moodleKey = null;

if ($pensum->tipo === 'MAESTRÍA') {
    $moodleKey = 'maestrias';
}

if ($pensum->tipo === 'DOCTORADO') {
    $moodleKey = 'doctorados';
}

if ($pensum->tipo === 'ESPECIALIDAD') {
    $moodleKey = 'especialidades';
}

if ($pensum->tipo === 'DIPLOMADO') {

    // DIPLOMADOS IA
    $diplomadosIA = [594,595,596,597,598,599,600,601,602];

    // DIPLOMADO TIC
    $diplomadosTIC = [609];

    // DIPLOMADOS SEP
    $diplomadosSEP = [603,604,605,606,607,608];

    if (in_array($pensum->id, $diplomadosIA)) {
        $moodleKey = 'diplomadosia';
    } elseif (in_array($pensum->id, $diplomadosTIC)) {
        $moodleKey = 'diplomadostic';
    } elseif (in_array($pensum->id, $diplomadosSEP)) {
        $moodleKey = 'diplomadossep';
    }
}

    
    
    
    
    
    
    
    
    

    if ($moodleKey) {

        // Obtener el ID de usuario en Moodle
        $sqlNota = "SELECT * FROM notas WHERE id = :id";
        $queryNota = $con->prepare($sqlNota);
        $queryNota->bindParam(':id', $idNota, PDO::PARAM_INT);
        $queryNota->execute();
        $notasData = $queryNota->fetch(PDO::FETCH_OBJ);

        if ($notasData) {
            $moodleUserId = $notasData->moodle_user_id;
            $suspended = 0;

            // Actualizar el estado de suspensión del usuario en Moodle
            require_once __DIR__ . '/../model/MoodleUser.php';

            $affectedRows = MoodleUser::updateSuspendedStatus($moodleKey, $moodleUserId, $suspended);

            $moodleMessage = '';

            if ($affectedRows) {
                $moodleMessage = ' Ahora ya puede realizar sus actividades en su curso con normalidad.';
            }
        }
    }
}

// ///////// Fin - Actualización de estado de suspensión en Moodle /////////