<?php
class Connection
{
    public static $mysqli;

    public static function getMoodleDBConnection($moodleKey)
    {
        $config = require __DIR__ . '/db_moodle.php';

        if (!isset($config[$moodleKey])) {
            die("Error: Configuración de base de datos no encontrada para $moodleKey");
        }

        $db = $config[$moodleKey];

        try {
            // Validar que $db tiene las claves necesarias
            if (!isset($db['host'], $db['database'], $db['username'], $db['password'])) {
                throw new Exception("Error: Configuración de la base de datos incompleta.");
            }

            $mysqli = new mysqli($db['host'], $db['username'], $db['password'], $db['database']);

            // Verificar si hay errores de conexión
            if ($mysqli->connect_error) {
                throw new Exception("Error de conexión a la base de datos: " . $mysqli->connect_error);
            }

            // Establecer el conjunto de caracteres
            if (!$mysqli->set_charset("utf8mb4")) {
                throw new Exception("Error al establecer el conjunto de caracteres: " . $mysqli->error);
            }
        } catch (Exception $e) {
            error_log("Error de conexión a MoodleDB: " . $e->getMessage());
            throw new Exception("No se pudo conectar a la base de datos de Moodle. Intente más tarde.");
        }
        
        return $mysqli;
    }
}
