<?php
require 'app/controller/Database.php';
require 'app/controller/DatabaseMy.php';
require 'app/controller/Executor.php';
require 'app/controller/Model.php';
require 'app/model/UsuariosData.php';
require 'app/model/ProgramasData.php';
require 'app/model/PersonasData.php';
require 'app/model/GruposData.php';
require 'app/model/ModulosData.php';
require 'app/model/NotasData.php';
require 'app/model/RequisitosTitulacionData.php';
require 'app/model/DepartamentosData.php';
require 'app/model/DatosNotificacionesData.php';
require 'app/model/InscripcionesData.php';
require 'app/model/InconsistenciasData.php';
require 'app/model/NotasMoodleAcadData.php';
//require 'app/model/NotificacionesData.php';
require 'app/model/SedesData.php';
require 'app/model/TransaccionesData.php';
require 'app/model/DepositosData.php';
require 'app/model/TramitesData.php';
require 'app/model/TmppersonasData.php';
require 'app/model/ProgramasLiteralData.php';
require("app/controller/Session.php");

class mvc_controllerPAGOLINEAUP
{

    /* METODO QUE MUESTRA LA PAGINA PRINCIPAL CUANDO NO EXISTEN NUEVAS ORDENES
   OUTPUT
   HTML | codigo html de la pagina   
   */

    public function __construct() {}

    function principal()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_POST) > 0)) {
            print "<script>window.location='index.php?action=loginSistema';</script>";
        } else {
            $pagina = $this->load_template('');
            $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
            ob_start();
            include 'app/views/sections/s.header.php';
            include 'app/views/sections/s.aside.php';
            include 'app/views/modules/m.principal.php';
            $table = ob_get_clean();
            $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);
            $this->view_page($pagina);
        }
    }

    function logoup()
    {
        echo '<img src="app/img/logoup.png">';
    }

    function miscuentas()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_POST) < 0)) {
            print "<script>window.location='index.php?action=loginSistema';</script>";
        } else {
            $pagina = $this->load_template('');
            $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
            ob_start();
            include 'app/views/sections/s.header.php';
            include 'app/views/sections/s.aside.php';
            include 'app/views/modules/m.bienvenida.php';
            $table = ob_get_clean();
            $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);
            $this->view_page($pagina);
        }
    }

    function loginSistema()
    {
        $pagina = $this->load_template_login('');
        $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
        ob_start();
        include 'app/views/modules/m.loginSistema.php';
        $table = ob_get_clean();
        $pagina = $this->replace_content('/\#CONTENIDO\#/ms', $mostrador . $table, $pagina);
        $this->view_page($pagina);
    }

    function loginAdmin()
    {
        $pagina = $this->load_template_login('');
        $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
        ob_start();
        include 'app/views/modules/admin/m.loginAdmin.php';
        $table = ob_get_clean();
        $pagina = $this->replace_content('/\#CONTENIDO\#/ms', $mostrador . $table, $pagina);
        $this->view_page($pagina);
    }

    function loginadm()
    {
        $found = false;
        $usuarid = null;
        $funcionUsuario = null;
        if ((Session::getUID() == "") && (count($_POST) > 0)) {
            session_start();
            $email = $_POST['email'];
            $pass = $_POST['password'];
            $securityCode = $_POST['securityCode'];

            if (strcasecmp($_SESSION['captcha'], $_POST['securityCode']) != 0) {
            //if (strcasecmp('local', 'local') != 0) {
                $message = "¡Ha introducido un código de seguridad incorrecto! Inténtelo de nuevo.";
                echo '<script>  window.location.href="index.php?action=admin&message=$message" </script>';
            } else {
                $usuarioEmail = UsuariosData::getByU($email);
                if ($usuarioEmail != null) {
                    $passwordDB = $usuarioEmail->password;
                    if (password_verify($pass, $passwordDB)) {
                        $found = true;
                        $usuarid = $usuarioEmail->id;
                    }
                }

                if ($found == true) {
                    Session::setUID($usuarid);
                    Session::setPWU($pass);
                    $pagina = $this->load_template('');
                    $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
                    ob_start();
                    include 'app/views/sections/s.headerAdmin.php';
                    include 'app/views/sections/s.asideAdmin.php';
                    include 'app/views/modules/admin/m.principalAdmin.php';

                    $table = ob_get_clean();
                    $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);
                    $this->view_page($pagina);
                } else {
                    echo '<script>  window.location.href="index.php?action=admin&no_found" </script>';
                }
            }
        } else {
            echo '<script>  window.location.href="index.php?action=admin" </script>';
        }
    }

    function preregistro()
    {
        $pagina = $this->load_template_login('');
        $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
        ob_start();
        include 'app/views/modules/m.formPreregistro.php';
        $table = ob_get_clean();
        $pagina = $this->replace_content('/\#CONTENIDO\#/ms', $mostrador . $table, $pagina);
        $this->view_page($pagina);
    }

    //LOGIN PARA PAGOS EN LINEA   
    function login()
    {
        $found = false;
        $usuarid = null;
        $funcionUsuario = null;
        if ((Session::getUID() == "") && (count($_POST) > 0)) {
            session_start();
            $carnet = $_POST['carnet'];
            $fechaNacimiento = $_POST['fechanacimiento'];
            $securityCode = $_POST['securityCode'];

            if (strcasecmp($_SESSION['captcha'], $_POST['securityCode']) != 0) {
            //if (strcasecmp('local', 'local') != 0) {
                $message = "¡Ha introducido un código de seguridad incorrecto! Inténtelo de nuevo.";
                echo '<script>  window.location.href="index.php?action=loginSistema&message=$message" </script>';
            } else {
                $participante = PersonasData::getByCiFn($carnet, $fechaNacimiento);
                if ($participante != null) {
                    $participanteCarnet = $participante->carnet;
                    $participanteId = $participante->id;
                    $found = true;
                }
                if ($found == true) {
                    Session::setUID($participanteId);
                    $pagina = $this->load_template('');
                    $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
                    ob_start();
                    include 'app/views/sections/s.header.php';
                    include 'app/views/sections/s.aside.php';
                    include 'app/views/modules/m.bienvenida.php';

                    $table = ob_get_clean();
                    $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);
                    $this->view_page($pagina);
                } else {
                    echo '<script>  window.location.href="index.php?action=loginSistema&no_found" </script>';
                }
            }
        } else {
            echo '<script>  window.location.href="index.php?action=loginSistema" </script>';
        }
    }

    function pagarppe()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_POST) > 0)) {
            print "<script>window.location='index.php?action=loginSistema';</script>";
        } else {
            $pagina = $this->load_template('');
            $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
            ob_start();
            include 'app/views/sections/s.header.php';
            include 'app/views/sections/s.aside.php';
            include 'app/controller/actions/pagosenlinea/a.getPagarPpe.php';
            $table = ob_get_clean();
            $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);
            $this->view_page($pagina);
        }
    }

    // MUESTRA FORMULARIO DE NOTIFICACION DE TRANSFERENCIA PAGO
    function notificacion()
    {
        session_start();
        $userSession = Session::getUID();
        $pagina = $this->load_template('');
        $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
        ob_start();
        include 'app/views/sections/s.header.php';
        include 'app/views/sections/s.aside.php';
        include 'app/views/modules/pagoLinea/m.notificacion.php';
        $table = ob_get_clean();
        $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);
        $this->view_page($pagina);
    }

    // funcion solo de prueba para simular el mensaje de la ppe
    function mensaje()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "")) {
            print "<script>window.location='index.php?action=loginSistema';</script>";
        } else {
            $pagina = $this->load_template('');
            $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
            ob_start();
            include 'app/views/sections/s.header.php';
            include 'app/views/sections/s.aside.php';
            include 'app/views/modules/pagoLinea/m.mensaje.php';
            $table = ob_get_clean();
            $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);

            $this->view_page($pagina);
        }
    }

    function consultaDeudas()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_POST) < 0)) {
            //  if(empty(($_POST)<0)){ 
            print "<script>window.location='index.php?action=loginSistema';</script>";
        } else {
            $pagina = $this->load_template('');
            $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
            ob_start();
            include 'app/views/sections/s.header.php';
            include 'app/views/sections/s.aside.php';
            include 'app/views/modules/pagoLinea/m.consultaDeudas.php';
            $table = ob_get_clean();
            $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);

            $this->view_page($pagina);
        }
    }

    function regDatosPagoTramite()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_POST) < 0)) {
            print "<script>window.location='index.php?action=loginSistema';</script>";
        } else {
            $pagina = $this->load_template('');
            $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
            ob_start();
            include 'app/views/sections/s.header.php';
            include 'app/views/sections/s.aside.php';
            include 'app/views/modules/pagoLinea/m.regDatosPagoTramite.php';
            $table = ob_get_clean();
            $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);

            $this->view_page($pagina);
        }
    }

    function misDepositos()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_POST) < 0)) {
            print "<script>window.location='index.php?action=loginSistema';</script>";
        } else {
            $pagina = $this->load_template('');
            $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
            ob_start();
            include 'app/views/sections/s.header.php';
            include 'app/views/sections/s.aside.php';
            include 'app/views/modules/pagoLinea/m.misDepositos.php';
            $table = ob_get_clean();
            $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);

            $this->view_page($pagina);
        }
    }

    function imprimirComprobante()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_GET) < 0)) {
            print "<script>window.location='index.php?action=loginSistema';</script>";
        } else {
            include 'app/views/modules/reportes/r.imprimirComprobante.php';
        }
    }

    function imprimirRegistro()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_GET) < 0)) {
            print "<script>window.location='index.php?action=loginSistema';</script>";
        } else {
            include 'app/views/modules/reportes/r.imprimirRegistro.php';
        }
    }

    function imprimirFichaHabilitacion()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_GET) < 0)) {
            print "<script>window.location='index.php?action=loginSistema';</script>";
        } else {
            include 'app/views/modules/reportes/r.imprimirFichaHabilitacion.php';
        }
    }

    //FUNCIONES PARA ADMINISTRADORES DEL SISTEMA
    function transacciones()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_POST) < 0)) {
            print "<script>window.location='index.php?action=admin';</script>";
        } else {
            $pagina = $this->load_template('');
            $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
            ob_start();
            include 'app/views/sections/s.headerAdmin.php';
            include 'app/views/sections/s.asideAdmin.php';
            include 'app/views/modules/admin/m.transacciones.php';
            $table = ob_get_clean();
            $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);

            $this->view_page($pagina);
        }
    }

    function reporte_pfo()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_POST) < 0)) {
            print "<script>window.location='index.php?action=admin';</script>";
        } else {
            $pagina = $this->load_template('');
            $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
            ob_start();
            include 'app/views/sections/s.headerAdmin.php';
            include 'app/views/sections/s.asideAdmin.php';
            include 'app/views/modules/admin/reportesadmin/m.reporte_pfo.php';
            $table = ob_get_clean();
            $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);

            $this->view_page($pagina);
        }
    }

    function reporte_excel()
    {
        ob_start();
        include_once 'app/views/modules/reportes/r.reporte_excel.php';
        ob_end_flush();
    }

    function addNuevaPersona()
    {
        session_start();
        $user_reg = Session::getUID();
        if ((count($_POST) > 0) && (Session::getUID() == "")) {
            include_once "app/views/sections/s.mensajes.php";
            date_default_timezone_set('America/La_Paz');
            $fechaActual = date("Y-m-d H:i:s");
            $estado = 0;
            $estadoSubidaPdf = false;
            $ci = isset($_POST["ci"]) ? mb_strtoupper(addslashes($_POST["ci"])) : "";
            $rda = isset($_POST["rda"]) ? mb_strtoupper(addslashes($_POST["rda"])) : "";
            $fec_nac = isset($_POST["fec_nac"]) ? mb_strtoupper(addslashes($_POST["fec_nac"])) : "";
            $nombre = isset($_POST["nombres"]) ? mb_strtoupper(addslashes($_POST["nombres"])) : "";
            $paterno = isset($_POST["paterno"]) ? mb_strtoupper(addslashes($_POST["paterno"])) : "";
            $materno = isset($_POST["materno"]) ? mb_strtoupper(addslashes($_POST["materno"])) : "";
            $email = isset($_POST["email"]) ? (($_POST["email"])) : "";
            $celular = isset($_POST["celular"]) ? mb_strtoupper(addslashes($_POST["celular"])) : "";

            $directorioPdfRda = "app/img/dirrdapdf/";
            $fileInfo = pathinfo($_FILES["file_rda"]["name"]);
            $fileName = $fileInfo["filename"]; // Nombre original del archivo sin la extension
            $fileExtension = $fileInfo["extension"]; // Extension del archivo
            // Generar un nombre único para el archivo
            $uniqueName = $fileName . "_" . time() . "." . $fileExtension; // Anade una marca de tiempo para hacerlo unico
            // Ruta completa donde se guardara el archivo
            $targetPath = $directorioPdfRda . $uniqueName;

            // Mover el archivo temporal al directorio de destino
            if (move_uploaded_file($_FILES["file_rda"]["tmp_name"], $targetPath)) {
                //echo "El archivo PDF se ha subido correctamente con el nombre: " . $uniqueName;
                $estadoSubidaPdf = true;
            }

            if ($estadoSubidaPdf) {
                $tmpPersonaObject = TmppersonasData::getByCi($ci);
                if ($tmpPersonaObject == null) {
                    $tmpPersonaRegistro = new TmppersonasData();
                    $tmpPersonaRegistro->carnet = $ci;
                    $tmpPersonaRegistro->cod_rda = $rda;
                    $tmpPersonaRegistro->fec_nac = $fec_nac;
                    $tmpPersonaRegistro->paterno = $paterno;
                    $tmpPersonaRegistro->materno = $materno;
                    $tmpPersonaRegistro->nombre = $nombre;
                    $tmpPersonaRegistro->celular = $celular;
                    $tmpPersonaRegistro->email = $email;
                    $tmpPersonaRegistro->rda_pdf = $uniqueName;
                    $tmpPersonaRegistro->created_at = $fechaActual;
                    $tmpPersonaRegistro->updated_at = $fechaActual;
                    $tmpPersonaRegistro->estado = $estado;

                    if ($tmpPersonaRegistro->create()) {
                        MensajeAlerta("correcto", "Registro realizado exitosamente, en minutos mas será habilitado", "index.php?action=loginPrincipal");
                    } else {

                        MensajeAlerta("error", "Error inesperado, intente mas tarde", "index.php?action=loginPrincipal");
                    }
                } else {
                    MensajeAlerta("error", "La persona con ci:$ci,ya realizó su preregistro", "index.php?action=preregistro");
                }
            } else {
                MensajeAlerta("error", "Error al subir archivo, verifique e intente nuevamente", "index.php?action=preregistro");
            }
        } else  print "<script>window.location='index.php?action=loginPrincipal';</script>";
    }

    function listnewpersonas()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() != "") && (count($_GET) < 0)) {
            print "<script>window.location='index.php?action=loginPrincipal';</script>";
        } else {
            $pagina = $this->load_template('');
            $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
            ob_start();
            include 'app/views/sections/s.header.php';
            include 'app/views/sections/s.aside.php';
            include 'app/views/modules/admin/m.listnewpersonas.php';
            $table = ob_get_clean();
            $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);
            $this->view_page($pagina);
        }
    }

    function inscripcionOferta()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_POST) < 0)) {
            print "<script>window.location='index.php?action=loginSistema';</script>";
        } else {
            $pagina = $this->load_template('');
            $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
            ob_start();
            include 'app/views/sections/s.header.php';
            include 'app/views/sections/s.aside.php';
            include 'app/views/modules/pagoLinea/m.inscripcionOferta.php';
            $table = ob_get_clean();
            $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);

            $this->view_page($pagina);
        }
    }

    // FUNCIONES VISTA FORMULARIOS  ENTIDADES
    function usuarios()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_POST) > 0)) {
            print "<script>window.location='index.php?action=loginSistema';</script>";
        } else {
            $pagina = $this->load_template('');
            $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
            ob_start();
            include 'app/views/sections/s.header.php';
            include 'app/views/sections/s.aside.php';
            include 'app/views/modules/configuracion/m.usuarios.php';
            $table = ob_get_clean();
            $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);

            $this->view_page($pagina);
        }
    }

    // MUESTRA FORMULARIO PARA REGISTRAR DATOS TRANSFERENCIA PAGO
    function registrarDatosPago()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_POST) < 0)) {
            print "<script>window.location='index.php?action=loginSistema';</script>";
        } else {
            $pagina = $this->load_template('');
            $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
            ob_start();
            include 'app/views/sections/s.header.php';
            include 'app/views/sections/s.aside.php';
            include 'app/views/modules/pagoLinea/m.registrarDatosPago.php';
            $table = ob_get_clean();
            $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);

            $this->view_page($pagina);
        }
    }

    //REGISTRAR DEPOSITO
    function registrar_deposito()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_POST) < 0)) {
            print "<script>window.location='index.php?action=loginSistema';</script>";
        } else {
            include 'app/controller/actions/bouchers/a.registrardeposito.php';
        }
    }

    // FORMULARIO PARA REGISTRAR REQUISITOS TITULACIÓN
    function registrar_requisitos_titulacion()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_POST) > 0)) {
            print "<script>window.location='index.php?action=loginSistema';</script>";
        } else {
            $pagina = $this->load_template('');
            $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
            ob_start();
            include 'app/views/sections/s.header.php';
            include 'app/views/sections/s.aside.php';
            include 'app/views/modules/titulaciones/m.requisitosTitulacion.php';
            $table = ob_get_clean();
            $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);

            $this->view_page($pagina);
        }
    }

    function guardar_requisitos_titulacion()
    {
        session_start();
        if ((Session::getUID() != "") && (count($_POST) > 0)) {
            include "app/controller/actions/titulaciones/a.getGuardarRequisitosTitulacion.php";
        } else  print "<script>window.location='index.php?action=loginSistema';</script>";
    }

    // MUESTRA LOS GRUPOS EN EL CURSO SELECCIONADO 
    function gruposCurso()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_POST) > 0)) {
            print "<script>window.location='index.php?action=loginSistema';</script>";
        } else {
            $pagina = $this->load_template('');
            $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
            ob_start();
            include 'app/views/sections/s.header.php';
            include 'app/views/sections/s.aside.php';
            include 'app/views/modules/inconsistencias/m.gruposCurso.php';
            $table = ob_get_clean();
            $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);

            $this->view_page($pagina);
        }
    }

    function imprimirRegAcadRevisado()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_GET) < 0)) {
            print "<script>window.location='index.php?action=loginSistema';</script>";
        } else {
            include 'app/views/modules/reportes/r.imprimirRegAcadRevisado.php';
        }
    }



















    function participantes()
    {
        session_start();
        $userSession = Session::getUID();
        if ((Session::getUID() == "") && (count($_POST) > 0)) {
            print "<script>window.location='index.php?action=loginSistema';</script>";
        } else {
            $pagina = $this->load_template('');
            $mostrador = $this->load_page('app/views/modules/m.mostrador.php');
            ob_start();
            include 'app/views/sections/s.header.php';
            include 'app/views/sections/s.aside.php';
            include 'app/views/modules/participantes/m.participantes.php';
            $table = ob_get_clean();
            $pagina = $this->replace_content('/\#CONTENIDO#/ms', $mostrador . $table, $pagina);
            $this->view_page($pagina);
        }
    }




    /* METODO QUE CARGA LAS PARTES PRINCIPALES DE LA PAGINA WEB
	INPUT
		$title | titulo en string F header
	OUTPUT
		$pagina | string que contiene toda el cocigo HTML de la plantilla 
	*/
    function load_template_login($title = 'Sin Titulo')
    { //funcion para que al empezar el sistema solo salga el login en el template
        $pagina = $this->load_page('app/views/page.php');
        //$menu_horiz = $this->load_page('views/sections/s.header.php');
        $container = $this->load_page('app/views/sections/s.contenido.php');
        $footer = $this->load_page('app/views/sections/s.f.php');

        //$pagina = $this->replace_content('/\#HEADE\#/ms' ,$menu_horiz, $pagina);//aqui esta modificado para que no encuentre el identificador
        $pagina = $this->replace_content('/\#CONTENIDO_INF\#/ms', $container, $pagina);
        $pagina = $this->replace_content('/\#FOOTER\#/ms', $footer, $pagina);
        return $pagina;
    }

    function load_template($title = 'Sin Titulo')
    {
        $pagina = $this->load_page('app/views/page.php');
        //   $menu_horiz = $this->load_page('app/views/sections/s.h.php');
        //  $aside = $this->load_page('app/views/sections/s.aside.php');
        $container = $this->load_page('app/views/sections/s.contenido.php');
        $footer = $this->load_page('app/views/sections/s.footer.php');

        //    $pagina = $this->replace_content('/\#HEADER\#/ms' ,$menu_horiz, $pagina);
        //	$pagina = $this->replace_content('/\#ASIDE\#/ms' ,$aside, $pagina);
        $pagina = $this->replace_content('/\#CONTENIDO_INF\#/ms', $container, $pagina);
        $pagina = $this->replace_content('/\#FOOTER\#/ms', $footer, $pagina);
        return $pagina;
    }



    /* METODO QUE CARGA UNA PAGINA DE LA SECCION VIEW Y LA MANTIENE EN MEMORIA
		INPUT
		$page | direccion de la pagina 
		OUTPUT
		STRING | devuelve un string con el codigo html cargado
	*/
    private function load_page($page)
    {
        return file_get_contents($page);
    }

    /* METODO QUE ESCRIBE EL CODIGO PARA QUE SEA VISTO POR EL USUARIO
		INPUT
		$html | codigo html
		OUTPUT
		HTML | codigo html		
	*/
    private function view_page($html)
    {
        echo $html;
    }

    /* PARSEA LA PAGINA CON LOS NUEVOS DATOS ANTES DE MOSTRARLA AL USUARIO
		INPUT
		$out | es el codigo html con el que sera reemplazada la etiqueta CONTENIDO
		$pagina | es el codigo html de la pagina que contiene la etiqueta CONTENIDO
		OUTPUT
		HTML 	| cuando realiza el reemplazo devuelve el codigo completo de la pagina
	*/
    private function replace_content($in, $out, $pagina)
    {
        return preg_replace($in, $out, $pagina);
    }
}
