# MoodleRest

MoodleRest is a PHP class to query Moodle REST webservices. You can make GET and POST requests.

## Quick start

Ensure you already have access to a Moodle webservice. To use this class you will need a token (generated by Moodle admin) with the necessary capabilities for the services you want to access.

**IMPORTANT**

If you need a detailed explanation about the **$parameters** format of the **request()** method, [read it in wiki](https://github.com/llagerlof/MoodleRest/wiki/Understanding-the-$parameters-in-request()-method).

## To the code

**You have 2 options to add this lib to your project:**

**Option One:** Use Composer to include it in your project.

- Inside your project directory create or modify the file `composer.json`:

```json
{
    "require": {
        "llagerlof/moodlerest": "2.4.0"
    }
}
```

- In the same directory of the `composer.json`, run:
```bash
$ composer install
```

- In your project, load the lib using composer autoloader:

```php
<?php
require_once dirname(__FILE__) . '/vendor/autoload.php'
```

**Option Two:** Include the **MoodleRest.php** class in your script.

```php
require_once('MoodleRest.php');
```



### Example 1

Query 2 Moodle groups with IDs 1 and 2, passing the server URL and token in constructor.

```php
$MoodleRest = new MoodleRest('http://127.0.0.1/moodle/webservice/rest/server.php', '8f12e614dae30735260a045313caa400');

$groups = $MoodleRest->request('core_group_get_groups', array('groupids' => array(1,2)));

print_r($groups);
```

### Example 2

Set the server and token in constructor and make a request to create a group on Moodle.

```php
$MoodleRest = new MoodleRest('http://127.0.0.1/moodle/webservice/rest/server.php', '8f12e614dae30735260a045313caa400');

$new_group = array('groups' => array(array('courseid' => 2, 'name' => 'Group name', 'description' => 'Group description')));

// The default request's METHOD is to make a GET request, but you can change it to POST. This is recommended when inserting and updating data.
$return = $MoodleRest->request('core_group_create_groups', $new_group, MoodleRest::METHOD_POST);

// If you want the requested URL
echo $MoodleRest->getUrl();
```

### Example 3

Query 2 pre-existent Moodle groups with IDs 1 and 2 (like example 1, without setting the server and token values in constructor).

```php
$MoodleRest = new MoodleRest();
$MoodleRest->setServerAddress("http://127.0.0.1/moodle/webservice/rest/server.php");
$MoodleRest->setToken('8f12e614dae30735260a045313caa400');
$MoodleRest->setReturnFormat(MoodleRest::RETURN_ARRAY); // Array is default. You can use RETURN_JSON or RETURN_XML too.

// You can enable debugging information using setDebug()
// When debugging is enabled, after each request the built URL and the result returned by the webservice function are printed to the standard output.
$MoodleRest->setDebug();
$arr = $MoodleRest->request('core_group_get_groups', array('groupids' => array(1,2)), MoodleRest::METHOD_GET);

// Note: You can make more requests using the same object
```

### Example 4

Make a request using chained methods and return the result as json.

```php
/*
The $parameters variable below translates in URL as:
    userlist[0][userid]=5&
    userlist[0][courseid]=2&
    userlist[1][userid]=4&
    userlist[1][courseid]=2"
*/
$parameters = array('userlist' => array(array('userid' => 5, 'courseid' => 2), array('userid' => 4, 'courseid' => 2)));

$json =
    (new MoodleRest())->setServerAddress("http://127.0.0.1/moodle/webservice/rest/server.php")->
    setToken('8f12e614dae30735260a045313caa400')->
    setReturnFormat(MoodleRest::RETURN_JSON)->request('core_user_get_course_user_profiles', $parameters);

echo $json;
```

More [examples](https://github.com/llagerlof/MoodleRest/wiki/MoodleRest-examples) in wiki.
