<?php
include '../../Database.php';
$base = new Database();
$con = $base->connect();
$idPersona = $_POST['idPersona'];

$sql = "
	SELECT pensums.inst, 
		pensums.especialidad || ' (' || pensums.version || ', ' || pensums.modalidad || '. ' || pensums.oferta || '/' || pensums.gestion || ') ' AS programa, 
		estados.id AS estado_id, 
		estados.estado, titulados.enviado, titulados.fecha, departamentos.departamento,
		CASE 
			WHEN estados.id = 27 THEN 'Comuníquese con Títulos de la UP' 
			ELSE '' 
		END AS obs, titulados.inscripcion_id
	FROM pensums
	JOIN titulados ON pensums.id = titulados.pensum_id
	JOIN estados ON estados.id = titulados.estado_id
	JOIN esfms ON esfms.id = titulados.sede_id
	JOIN departamentos ON departamentos.id = esfms.departamento_id
	WHERE titulados.persona_id = $idPersona

	union all

	SELECT pensums.inst, 
		pensums.especialidad || ' (' || pensums.version || ', ' || pensums.modalidad || '. ' || pensums.oferta || '/' || pensums.gestion || ') ' AS programa, 
		estados.id AS estado_id, 
		CASE
			WHEN estados.id in (25, 26) THEN 'En proceso de Titulación'
			ELSE estados.estado
		END AS estado, false AS enviado, null AS fecha, null as departamento,
		CASE 
			WHEN estados.id = 27 THEN requisito_titulacion.obs 
			ELSE ''
		END AS obs, requisito_titulacion.inscripcion_id
	FROM pensums
	JOIN inscripciones ON pensums.id = inscripciones.pensum_id
	JOIN requisito_titulacion ON inscripciones.id = requisito_titulacion.inscripcion_id
	JOIN estados ON estados.id = requisito_titulacion.estado_id
	WHERE inscripciones.persona_id = $idPersona and inscripciones.estado_id <> 8

	union all

	SELECT pensums.inst, 
		pensums.especialidad || ' (' || pensums.version || ', ' || pensums.modalidad || '. ' || pensums.oferta || '/' || pensums.gestion || ') ' AS programa, 
		inscripciones.estado_id, estados.estado, false as enviado, null as fecha, null as departamento, '' as obs, inscripciones.id as inscripcion_id
	FROM pensums
	JOIN inscripciones ON pensums.id = inscripciones.pensum_id
	JOIN estados ON estados.id = inscripciones.estado_id
	WHERE inscripciones.persona_id = $idPersona and inscripciones.estado_id = 11 and inscripciones.id not in (
		select requisito_titulacion.inscripcion_id
		from requisito_titulacion
		join inscripciones on inscripciones.id = requisito_titulacion.inscripcion_id
		where inscripciones.persona_id = $idPersona)
	ORDER BY inst, programa
";

$query = $con->prepare($sql);

$result = $query->execute();

if ($result) {
    $data = array();
    $num = 0;
    while ($reg = $query->fetch(PDO::FETCH_OBJ)) {        
        $num++;
        $data[] = array(
            "0" => $num,
            "1" => $reg->inst,
            "2" => $reg->programa,
			"3" => ($reg->estado_id == 8 
				? (
					$reg->enviado 
						? $reg->estado . ' <br> <span class="badge badge-pill bg-success text-white font-weight-normal" title="Indica si su Título ya fue enviado a su región">Enviado (' . $reg->departamento . ')</span>' 
						: (
							($reg->fecha && intval(substr($reg->fecha, 0, 4)) >= 2025)
								? $reg->estado . ' <br> <span class="badge badge-pill bg-danger text-white font-weight-normal" title="Indica si su Título ya fue enviado a su región">No enviado</span>'
								: $reg->estado
						)
				)
				: $reg->estado
			),
            "4" => $reg->obs,
			"5" => $reg->estado_id == 11 ? "<button class='btn btn-primary btn-sm' onclick='registrarRequisitos($reg->inscripcion_id)'>Registrar requisitos</button>" : "<button class='btn btn-success btn-sm' onclick='imprimirFichaHabilitacion($reg->inscripcion_id)' title='Imprimir Ficha de Habilitación'><i class='fa fa-print'></i></button>"
        );
    }
    $results = array(
        "sEcho" => 1, //Información para el datatables
        "iTotalRecords" => count($data), //enviamos el total registros al datatable
        "iTotalDisplayRecords" => count($data), //enviamos el total registros a visualizar
        "aaData" => $data
    );
    echo json_encode($results);
    exit();    
} else {
    echo 'error en la conexión a la base de datos';
}