<?php
$base = new Database();
$con = $base->connect();
$inscripcion_id = isset($_REQUEST['inscripcion_id']) ? base64_decode($_REQUEST['inscripcion_id']) : null;

//Recuperamos el tipo de programa y la institución
$sql = "
    select pensums.inst, pensums.tipo, programas.id as programa_id, inscripciones.persona_id, inscripciones.pensum_id
    from inscripciones
    join pensums on pensums.id = inscripciones.pensum_id
    join programas on programas.nombre = pensums.tipo
    where inscripciones.id = $inscripcion_id
";
$query = $con->prepare($sql);
$result = $query->execute();
if ($result) {
    $reg = $query->fetch(PDO::FETCH_OBJ);
    $inst = $reg->inst;
    $tipo = $reg->tipo;
    $programa_id = $reg->programa_id;
    $personaId = $reg->persona_id;
    $pensumId = $reg->pensum_id;
}

//Recuperamos la fila de la tabla requisito_titulo con la institución y el id de programa
$sql = "
    select *
    from requisito_titulo
    where programa_id = $programa_id and inst_req = '$inst'
";
$query = $con->prepare($sql);
$result = $query->execute();
if ($result) {
    $reg = $query->fetch(PDO::FETCH_OBJ);
    $requisitos = [];
    for ($i = 1; $i <= 11; $i++) {
        $campo = "requisito_$i";
        if (isset($reg->$campo) && !in_array($reg->$campo, [0, 6, 7, 8])) {
            $requisitos[$campo] = $reg->$campo;
        }
    }
}

if (!empty($requisitos)) {
    $requisitos_ids = implode(',', array_values($requisitos));
    $sql = "
        select *
        from requisitos
        where id in ($requisitos_ids)
        order by id
    ";
    $query = $con->prepare($sql);
    $result = $query->execute();
    if ($result) {
        $requisitos_detalles = $query->fetchAll(PDO::FETCH_OBJ);
        $i = 0;
        foreach ($requisitos_detalles as $detalle) {
            $i++;
            echo "<tr>";
            echo "<td>{$i}</td>";
            echo "<th>{$detalle->requisito}</th>";
            $required = $detalle->id != 11 ? 'required' : '';
            echo "<td><input type='checkbox' name='requisito[]' value='{$detalle->id}' {$required}></td>";
            echo "</tr>";
        }
    }

    //Recuperamos los datos del depósito
    $deposito = DepositosData::getByIdperIdpenConcep($personaId, $pensumId, 'TIT');
    if (!$deposito) {
        echo "<tr>";
        echo "<td colspan='3'><div class='alert alert-danger'><strong>No se encontró pago por concepto de titulación</strong>. Tome en cuenta que debe ser necesariamente por código CPT</div></td>";
        echo "</tr>";
    }    
    $i++;
    echo "<tr>";
    echo "<td>{$i}</td>";
    echo "<th>Nro. Depósito</th>";
    echo "<td><input type='text' value='" . ($deposito ? $deposito->nro_deposito : '') . "' disabled required></td>";
    echo "</tr>";
    $i++;
    echo "<tr>";
    echo "<td>{$i}</td>";
    echo "<th>Fecha Depósito</th>";
    $fecha_deposito = $deposito ? date('d/m/Y', strtotime($deposito->fecha_deposito)) : '';
    echo "<td><input type='text' value='" . $fecha_deposito . "' disabled required></td>";
    echo "</tr>";
    $i++;
    echo "<tr>";
    echo "<td>{$i}</td>";
    echo "<th>Monto Depósito</th>";
    echo "<td><input type='text' value='" . ($deposito ? $deposito->monto : '') . "' disabled required></td>";
    echo "</tr>";
}
