<?php
include_once "app/views/sections/s.mensajes.php";
?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<?php
$user_reg=Session::getUID();
$fechaActual = date('Y-m-d H:i:s');
$requisitos = isset($_POST['requisito']) ? $_POST['requisito'] : [];
$requisitos = implode(',', $requisitos);

$idInscripcion = $_POST['inscripcion_id'];

$verificar = RequisitosTitulacionData::getByIdInscripcion($idInscripcion);

if ($verificar) {
    echo "<script type='application/javascript'>
        Swal.fire({
            icon: 'info',
            title: 'Requisitos ya registrados',
            text: 'Los requisitos de titulación para este programa ya han sido registrados anteriormente.',
            confirmButtonText: 'Entiendo'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = 'index.php?action=consultaDeudas';
            }
        });
    </script>";
    exit;
}


$reqTitulacion = new RequisitosTitulacionData($idInscripcion, $requisitos, 25, '', $user_reg, $fechaActual, $fechaActual, 0);

if ($reqTitulacion->add()) {    
    echo "<script type='application/javascript'>
        Swal.fire({
            icon: 'success',
            title: '¡Éxito!',
            text: 'Los requisitos de titulación han sido registrados correctamente.',
            confirmButtonText: 'Genial!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = 'index.php?action=consultaDeudas';
            }
        });
    </script>";
    exit;
} else {
    echo "<script type='application/javascript'>
        Swal.fire({
            icon: 'error',
            title: '¡Error, algo salió mal!',
            text: 'No se ha logrado registrar los datos. Intente más tarde.',
            confirmButtonText: 'Entiendo'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = 'index.php?action=consultaDeudas';
            }
        });
    </script>";
    exit;
}