<?php

$sqlparticipante = "
    select 2 as inscripcion_tipo_id, COALESCE(sum(depositos.monto), 0) as total
    from depositos
    join pensums on pensums.id = depositos.pensum_id
    where depositos.concepto = 'PFO' and pensums.id = $inscripcionPensumId and depositos.persona_id = $idPersona and depositos.fecha_deposito <= '$fechaLimiteEstudiantesStr'
    union
    select 1 as inscripcion_tipo_id, COALESCE(sum(depositos.monto), 0) as total
    from depositos
    join pensums on pensums.id = depositos.pensum_id
    where depositos.concepto = 'PFO' and pensums.id = $inscripcionPensumId and depositos.persona_id = $idPersona and depositos.fecha_deposito > '$fechaLimiteEstudiantesStr'
    order by inscripcion_tipo_id desc";
$consulta = $con->prepare($sqlparticipante);
$resultado = $consulta->execute();
$modoEstudiante = $consulta->fetch(PDO::FETCH_OBJ);
$modoRegular = $consulta->fetch(PDO::FETCH_OBJ);
$totalEstudiante = $modoEstudiante->total;
$totalRegular = $modoRegular->total;
$cuotas = (int)($totalEstudiante / 150);
$cuotasPendientes = 5 - $cuotas;
if ($cuotasPendientes < 5) {
    $costoPrograma = $totalEstudiante + $cuotasPendientes * 300;
    $totalCuotas = $totalEstudiante + $totalRegular;
    $cuotasPendientes = max(0, ceil(($costoPrograma - $totalCuotas) / 300));
}