<?php

$fechaLimiteEstudiantes = new DateTime('2025-12-21 03:59:59'); // Fecha límite establecida. Dependerá de la RM o norma vigente que indique fecha de clausura de ESFM 20/12/2024 ojo mary
$fechaLimiteEstudiantesStr = $fechaLimiteEstudiantes->format('Y-m-d H:i:s');
$fechaHoy = new DateTime(); // Fecha actual
$oferta = (int)$fechaLimiteEstudiantes->format('Y');; // Año como entero

$inscripcionTipoId = 0;
$inscripcionPensumId = 0;

if ($fechaHoy > $fechaLimiteEstudiantes) {
    try {
        $sql = "
        SELECT inscripcion_tipo_id, pensum_id
        FROM inscripciones
        JOIN pensums ON pensums.id = inscripciones.pensum_id
        WHERE persona_id = :idPersona and pensums.gestion = :oferta and inscripciones.inscripcion_tipo_id = 2
    ";

        $queryTipoParticipante = $con->prepare($sql);
        $queryTipoParticipante->bindParam(':idPersona', $idPersona, PDO::PARAM_INT);
        $queryTipoParticipante->bindParam(':oferta', $oferta, PDO::PARAM_INT);
        $queryTipoParticipante->execute();
        $tipoParticipante = $queryTipoParticipante->fetch(PDO::FETCH_OBJ);

        if ($tipoParticipante) {
            $inscripcionTipoId = $tipoParticipante->inscripcion_tipo_id;
            $inscripcionPensumId = $tipoParticipante->pensum_id;
        }
    } catch (PDOException $e) {
        error_log('Database error: ' . $e->getMessage());
        echo 'Ocurrió un error al procesar su solicitud. Por favor, inténtelo de nuevo más tarde.';
        exit();
    }
}
