<?php
include '../../Database.php';
$base = new Database();
$con = $base->connect();
$idPersona = $_POST['idPersona'];
date_default_timezone_set("America/La_Paz");
$fechaActual = date("Y-m-d");
$fechaFinal = strtotime($fechaActual);

$sql = "WITH transacciones_cte AS (
    -- Primera consulta: transacciones con filtros aplicados desde el principio
    SELECT TT.id, TT.codigo, TT.cuenta_bancaria, TT.monto_total, 
           TT.codigo_transaccion AS transaccion_codigo, 
           TT.estado AS estado_t, TT.updated_at, TT.tramite_id, TT.concepto, TT.estado_uso,
           P.carnet, P.paterno, P.materno, P.nombre,
           PEN.inst, PEN.gestion, PEN.codigo AS codigo_pensum, PEN.especialidad, PEN.version, PEN.modalidad,
           TR.descripcion,
           N.codigo_seguimiento, N.detalle, N.estado AS estado_n, N.id AS idn
    FROM transacciones TT
    LEFT JOIN notificaciones N ON N.codigo_seguimiento = TT.codigo_transaccion
    INNER JOIN personas P ON TT.persona_id = P.id AND P.id = $idPersona
    INNER JOIN pensums PEN ON TT.codigo = PEN.id
    INNER JOIN tramites TR ON TT.tramite_id = TR.id
)

-- Consulta combinada con depósitos usando LEFT JOIN para optimización
SELECT transacciones_cte.id, transacciones_cte.codigo, transacciones_cte.cuenta_bancaria, transacciones_cte.monto_total, 
       transacciones_cte.transaccion_codigo, 
       transacciones_cte.estado_t, transacciones_cte.updated_at, transacciones_cte.tramite_id, transacciones_cte.concepto, transacciones_cte.estado_uso,
       transacciones_cte.carnet, transacciones_cte.paterno, transacciones_cte.materno, transacciones_cte.nombre,
       transacciones_cte.inst, transacciones_cte.gestion, transacciones_cte.codigo_pensum, transacciones_cte.especialidad, transacciones_cte.version, transacciones_cte.modalidad,
       transacciones_cte.descripcion, transacciones_cte.codigo_seguimiento, transacciones_cte.detalle, transacciones_cte.estado_n, transacciones_cte.idn
FROM transacciones_cte

-- Consulta de depósitos, usando LEFT JOIN para evitar NOT EXISTS
UNION ALL
SELECT depositos.id, pensums.id, 0, depositos.monto, 
       depositos.nro_deposito AS transaccion_codigo,  
       'REGISTRADO' AS estado_t, depositos.updated_at, depositos.tramite_id, depositos.concepto, 0,
       personas.carnet, personas.paterno, personas.materno, personas.nombre,
       pensums.inst, pensums.gestion, pensums.codigo AS codigo_pensum, pensums.especialidad, pensums.version, pensums.modalidad,
       'Registro de depósito' AS descripcion, depositos.nro_deposito AS codigo_seguimiento, 'Registro de depósito' AS detalle, 'REGISTRADO' AS estado_n, notas.id AS idn
FROM depositos
JOIN personas ON depositos.persona_id = personas.id
JOIN pensums ON depositos.pensum_id = pensums.id
JOIN notas ON notas.modulo_pagado = depositos.id OR notas.seg_inst_pagado = depositos.id
LEFT JOIN transacciones_cte ON transacciones_cte.transaccion_codigo = depositos.nro_deposito
WHERE personas.id = $idPersona and depositos.user_id_reg = $idPersona
  AND transacciones_cte.transaccion_codigo IS NULL  -- Excluimos registros coincidentes
ORDER BY updated_at DESC;
";


$query = $con->prepare($sql);

$result = $query->execute();
if ($result) {
  $data = array();
  $num = 0;
  while ($reg = $query->fetch(PDO::FETCH_OBJ)) {
    $idt = $reg->id;
    $idn = $reg->idn;
    $eut = $reg->estado_uso;
    $fecha = $reg->updated_at;
    $fecha = date('Y-m-d', strtotime($fecha));
    $fechaInicioDep = date($fecha);
    $fechaInicio = strtotime($fechaInicioDep);
    $estadoUso = '';
    $estadoTransaccion = false;
    $vigenciaTransaccion = false;
    $tiempoTransaccion = 0;
    $dias = 0;
    $nombres = $reg->paterno . ' ' . $reg->materno . ' ' . $reg->nombre;

    if ($reg->estado_t == 'EN-PROCESO' && $reg->estado_uso == 0 && $reg->estado_n !== '') {
      $estadoUso = '<label class="badge badge-warning" title="Transacción no completada"> En proceso </label>';
    } else if ($reg->estado_n == 'PROCESADO' && $reg->estado_uso == 0) {
      $estadoUso = '<a href="index.php?action=imprimirComprobante&idt=' . base64_encode($idt) . '&idn=' . base64_encode($idn) . '&eut=' . base64_encode($eut) . '" class="btn btn-success btn-sm" title="IMPRIMIR" target="_blank"> <i class="fa fa-print" </i> </a>';
    } else if ($reg->estado_t == 'PROCESADO' && $reg->estado_uso == 1) {
      $estadoUso = '<a href="index.php?action=imprimirComprobante&idt=' . base64_encode($idt) . '&idn=' . base64_encode($idn) . '&eut=' . base64_encode($eut) . '" class="btn btn-primary btn-sm" title="IMPRIMIR" target="_blank"> <i class="fa fa-print" </i> </a>';
      $estadoTransaccion = true;
    } else if ($reg->estado_n == 'EXPIRADO' && $reg->estado_uso == 0) {
      $estadoUso = '<label class="badge badge-danger" title="Transacción expirada"> Expirado </label>';
      $estadoTransaccion = false;
    } else if ($reg->estado_n == 'REGISTRADO' && $reg->estado_uso == 0) {
      $estadoUso = '<a href="index.php?action=imprimirRegistro&idt=' . base64_encode($idt) . '&idn=' . base64_encode($idn) . '&eut=' . base64_encode($eut) . '" class="btn btn-success btn-sm" title="IMPRIMIR" target="_blank"> <i class="fa fa-print" </i> </a>';
    }
    $tiempoTransaccion = ($fechaFinal - $fechaInicio) / 86400;
    $dias = round($tiempoTransaccion, 0, PHP_ROUND_HALF_UP);

    // if($dias < 200 || $dias==0){ 
    $num++;
    if ($reg->estado_t != 'EN-PROCESO'){
        $data[] = array(
          "0" => $num,
          "1" => '<a title="' . $reg->especialidad . '">' . $reg->codigo_pensum . ' (' . $reg->version . ')</a>',
          "2" => $reg->transaccion_codigo,
          "3" => '<center>' . $reg->monto_total . ' Bs. </center>',
          "4" => $fecha,
          "5" => $reg->descripcion,
          "6" => '<center>' . $estadoUso . '<center>',
          "19" => $estadoTransaccion
        );
    }
    //  }
  }
  $results = array(
    "sEcho" => 1, //Informacion para el datatables
    "iTotalRecords" => count($data), //enviamos el total registros al datatable
    "iTotalDisplayRecords" => count($data), //enviamos el total registros a visualizar
    "aaData" => $data
  );
  echo json_encode($results);
  exit();
} else {
  echo 'Error en la conexion a la base de datos';
}
