<?php
include '../../Database.php';
$base = new Database();
$con = $base->connect();

$sql ="SELECT G.vigente,G.id,G.n_grupo,G.esfm_id,
              M.codigo,M.modulo,M.semestre_id,
              P.especialidad,P.version,P.modalidad,P.gestion,
              PER.id AS idper,PER.carnet,PER.paterno,PER.materno,PER.nombre,
              INC.estado,INC.obs,INC.con_grupos
   
              FROM grupos as G
              INNER JOIN modulos AS M ON
              G.modulo_id=M.id 
              INNER JOIN pensums AS P ON
              P.id=M.pensum_id 
              INNER JOIN personas AS PER ON
              PER.id=G.persona_id
              LEFT JOIN inconsistencias_acad_moodle AS INC ON
              INC.grupo_id=G.id
              WHERE G.vigente=FALSE
              GROUP BY G.id,M.codigo,M.modulo,M.semestre_id,P.especialidad,P.version,PER.id,PER.paterno,PER.materno,PER.nombre,P.modalidad,P.gestion,PER.carnet,G.vigente,G.n_grupo,G.esfm_id,INC.estado,INC.obs,INC.con_grupos
              ORDER BY P.gestion,P.especialidad,M.semestre_id
    ";


$query=$con->prepare($sql);

$result=$query->execute();

if($result){
    $data= Array();
    $num=0;
    //$total=$reg->apr+$reg->rpr+$reg->srn;
   while ($reg=$query->fetch(PDO::FETCH_OBJ)){
      $num++;
      $estado='SIN REVISAR';
      if($reg->estado=='Consolidado'){
          $estado='CONSOLIDADO';
      }else if($reg->estado=='Observado'){
          $estado='OBSERVADO';
      }
      $data[]=array(
        "0"=>$num,
        "1"=>$reg->gestion,
        "2"=>'<a title="'.$reg->especialidad.'">'.$reg->especialidad.' <br> ['.$reg->version.' - '.$reg->modalidad .']<b> '.$reg->codigo.' - '.$reg->modulo.'</b> </a>',
        "3"=>'<center>'.$reg->semestre_id.'</center>',
        "4"=>$reg->n_grupo.' - G: '.$reg->id,
        "5"=>$reg->idper.' - '.$reg->paterno.' '.$reg->materno.' '.$reg->nombre.' - '.$reg->carnet,
        "6"=>$estado,
        "7"=>$reg->obs,
        "8"=>($estado=='OBSERVADO'|| $estado=='CONSOLIDADO')?'<a href="index.php?action=imprimirRegAcadRevisado&idGrupo='.base64_encode($reg->id).'&congrupos='.base64_encode($reg->con_grupos).'" target="_blank"  class="btn btn-primary btn-mb" title="OBSERVADO"><i class="fa fa-print"></i> Imprimir </i> </a>':'',
        "10"=>$estado
       
        );
      }
    $results = array(
      "sEcho"=>1, //Información para el datatables
      "iTotalRecords"=>count($data), //enviamos el total registros al datatable
      "iTotalDisplayRecords"=>count($data), //enviamos el total registros a visualizar
      "aaData"=>$data);
    echo json_encode($results);
    exit();
    }else {
       echo'error en la conexión a la base de datos';
    }    
?>