<?php
include '../../Database.php';

try {
    $base = new Database();
    $con = $base->connect();

    // Recibiendo los datos enviados por POST
    $idTmpDep = $_POST['tmp_dep_id'];
    $idTramite = $_POST['tramite_id'];
    $idNota = $_POST['nota_id'];
    $idPensum = $_POST['pensum_id'];
    $idPersona = $_POST['persona_id'];
    $nroDeposito = $_POST['nro_deposito'];
    $fechaDeposito = $_POST['fecha_deposito'];
    $montoDeposito = $_POST['monto'];
    $arancel = $_POST['costo'];
    $costoTotal = $_POST['costo_total'];

    $idUsuario = $idPersona;

    // Configurar la zona horaria para Bolivia
    date_default_timezone_set('America/La_Paz');

    $fecha = new DateTime($fechaDeposito);

    $fechaDep = $fecha->format('Y-m-d');

    //Verificar si el monto es correcto
    if (!in_array($montoDeposito, [$arancel, $costoTotal, 150])) {
        echo json_encode([
            'status' => 'error',
            'message' => 'El monto de depósito no corresponde a la cuota según arancel.'
        ]);
        exit;
    }

    // Verificar si el monto de depósito no supera el costo del programa
    $sqlSum = "SELECT SUM(monto) as total_depositado FROM DEPOSITOS WHERE persona_id = :persona_id AND pensum_id = :pensum_id AND concepto = 'PFO'";
    $querySum = $con->prepare($sqlSum);
    $querySum->bindParam(':persona_id', $idPersona, PDO::PARAM_INT);
    $querySum->bindParam(':pensum_id', $idPensum, PDO::PARAM_INT);
    $querySum->execute();
    $resultSum = $querySum->fetch(PDO::FETCH_OBJ);

    $totalDepositado = $resultSum->total_depositado + $montoDeposito;

    if ($totalDepositado > $costoTotal) {
        echo json_encode([
            'status' => 'info',
            'message' => 'El monto de depósito que intenta registrar supera el costo total del programa.'
        ]);
        exit;
    }

    // Verificar si el nro_deposito ya existe en la tabla DEPOSITOS
    $sqlCheck = "SELECT COUNT(*) FROM DEPOSITOS WHERE nro_deposito = '$nroDeposito'";
    $queryCheck = $con->prepare($sqlCheck);
    $queryCheck->execute();
    $exists = $queryCheck->fetchColumn();

    if ($exists) {
        // Si el depósito ya existe, devolver un error
        echo json_encode([
            'status' => 'error',
            'message' => 'El número de depósito ya ha sido registrado.'
        ]);
    } else {
        $concepto = '';
        // Consulta SQL para obtener el trámite por ID
        $sql = "SELECT concepto FROM tramites WHERE id = :id";
        $query = $con->prepare($sql);
        $query->bindParam(':id', $idTramite, PDO::PARAM_INT);
        $query->execute();

        $tramite = $query->fetch(PDO::FETCH_OBJ);
        if ($tramite) {
            $concepto = $tramite->concepto;
        }
        $fechaActual = date('Y-m-d H:i:s');
        // Insertar el nuevo depósito en la tabla DEPOSITOS
        $sqlInsert = "INSERT INTO DEPOSITOS (pensum_id, persona_id, nro_deposito, fecha_deposito, monto, cantidad, concepto, confirmado, user_id_reg, user_id_cfr, tramite_id, created_at, updated_at) 
                    VALUES ($idPensum, $idPersona, $nroDeposito, '$fechaDep', $montoDeposito, 0, '$concepto', 'f', $idUsuario, 0, $idTramite, '$fechaActual', '$fechaActual')";
        $queryInsert = $con->prepare($sqlInsert);

        if ($queryInsert->execute()) {
            $newId = $con->lastInsertId(); // Obtener la última ID insertada
            $sqlUpdateTmpDep = "UPDATE TMP_DEPS SET confirmado = 't', persona_id = $idPersona WHERE id = $idTmpDep";
            $queryUpdateTmpDep = $con->prepare($sqlUpdateTmpDep);
            $queryUpdateTmpDep->execute();
            if ($concepto == 'PFO') {
                $sqlUpdateNota = "UPDATE NOTAS SET modulo_pagado = $newId where id = $idNota";
            } else {
                $sqlUpdateNota = "UPDATE NOTAS SET seg_inst_pagado = $newId, permitir_seg_inst = 'f' where id = $idNota";
            }
            $queryUpdateNota = $con->prepare($sqlUpdateNota);
            $queryUpdateNota->execute();

            include '../../../moodle/enable_user.php';

            echo json_encode([
                'status' => 'success',
                'message' => 'Depósito registrado exitosamente. No olvide presentar su depósito en la coordinación de su región.' . $moodleMessage
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Error al registrar el depósito.'
            ]);
        }
    }
} catch (PDOException $e) {
    // Registrar el error en un archivo de log o sistema de monitoreo
    error_log("Error en la base de datos: " . $e->getMessage());

    // Mensaje genérico para el usuario
    echo json_encode([
        'status' => 'error',
        'message' => 'Ocurrió un problema al procesar su solicitud. Inténtelo más tarde.'
    ]);
}

exit;
