<?php
include '../../Database.php';

try {
    $base = new Database();
    $con = $base->connect();
    
    // Recibiendo los datos enviados por POST
    $nroDeposito = $_POST['nroDeposito'];
    $fechaDeposito = $_POST['fechaDeposito'];
    $montoDeposito = $_POST['montoDeposito'];
    
    $fecha = new DateTime($fechaDeposito);

    $fechaDep = $fecha->format('Y-m-d');

    // Preparar la consulta para evitar inyección SQL
    $sql = "SELECT * FROM tmp_deps WHERE fecha_deposito = '$fechaDep' AND nro_deposito = '$nroDeposito' AND monto = $montoDeposito";
    $query = $con->prepare($sql);

    // Ejecutar la consulta
    $query->execute();

    // Verificar si se encontraron resultados
    if ($query->rowCount() > 0) {
        $results = $query->fetchAll(PDO::FETCH_ASSOC);

        // Enviar los resultados como JSON al frontend
        echo json_encode([
            'status' => 'success',
            'data' => $results
        ]);
    } else {
        // Si no se encontraron registros
        echo json_encode([
            'status' => 'error',
            'message' => 'No se encontraron registros con los datos proporcionados.'
        ]);
    }

} catch (PDOException $e) {
    // Manejo de errores de la base de datos
    echo json_encode([
        'status' => 'error',
        'message' => 'Error en la conexión a la base de datos: ' . $e->getMessage()
    ]);
}

exit;
?>
