<?php
include '../../Database.php';
$base = new Database();
$con = $base->connect();
date_default_timezone_set("America/La_Paz");
$fechaActual=date("Y-m-d");
 $fechaFinal=strtotime($fechaActual);

$sql="SELECT TT.id,TT.codigo,TT.cuenta_bancaria,TT.monto_total,TT.codigo_transaccion,TT.estado AS estado_t,TT.updated_at,TT.tramite_id,TT.concepto,TT.estado_uso,
        P.carnet,P.paterno,P.materno,P.nombre,
        PEN.inst,PEN.gestion,PEN.codigo,PEN.especialidad,PEN.version,PEN.modalidad,
        TR.descripcion,
        N.codigo_seguimiento,N.detalle,N.estado AS estado_n,N.id AS idn
      FROM transacciones AS TT
      LEFT JOIN notificaciones AS N ON
      N.codigo_seguimiento=TT.codigo_transaccion
      INNER JOIN personas AS P ON
      TT.persona_id=P.id
      INNER JOIN pensums AS PEN ON
      TT.codigo=PEN.id
      INNER JOIN tramites AS TR ON
      TT.tramite_id=TR.id
      ORDER BY TT.updated_at desc
      ";
    

$query=$con->prepare($sql);

$result=$query->execute();
if($result){
    $data= Array();
    $num=0;
    while ($reg=$query->fetch(PDO::FETCH_OBJ)){
       $idt=$reg->id;
       $idn=$reg->idn; 
       $eut=$reg->estado_uso;
       $fecha=$reg->updated_at;
       $fecha=date('Y-m-d',strtotime($fecha));
       $fechaInicioDep=date($fecha);
       $fechaInicio=strtotime($fechaInicioDep);
       $estadoUso='';
       $estadoTransaccion=false;
       $tiempoTransaccion=0;
       $dias=0;
       $nombres=$reg->paterno.' '.$reg->materno.' '.$reg->nombre;
       if($reg->estado_t=='EN-PROCESO' && $reg->estado_uso==0 && $reg->estado_n !==''){
        $estadoUso='<label class="badge badge-warning" title="Transacción no completada"> En proceso </label>';
        $tiempoTransaccion=($fechaFinal - $fechaInicio) / 86400;
        $dias = round($tiempoTransaccion, 0, PHP_ROUND_HALF_UP);
       }else if($reg->estado_n=='PROCESADO' && $reg->estado_uso==0){
         $estadoUso='<a href="index.php?action=imprimirComprobante&idt='.base64_encode($idt).'&idn='.base64_encode($idn).'&eut='.base64_encode($eut).'" class="btn btn-success btn-sm" title="IMPRIMIR" target="_blank"> <i class="fa fa-print" </i> </a>';
       }else if($reg->estado_t=='PROCESADO' && $reg->estado_uso==1){
        $estadoUso='<a href="index.php?action=imprimirComprobante&idt='.base64_encode($idt).'&idn='.base64_encode($idn).'&eut='.base64_encode($eut).'" class="btn btn-primary btn-sm" title="IMPRIMIR" target="_blank"> <i class="fa fa-print" </i> </a>';
        $estadoTransaccion=true;
       }else if($reg->estado_n=='EXPIRADO' && $reg->estado_uso==0){
        $estadoUso='<label class="badge badge-danger" title="Transacción expirada"> Expirado </label>';
        $estadoTransaccion=false;
        $tiempoTransaccion=($fechaFinal - $fechaInicio) / 86400;
        $dias = round($tiempoTransaccion, 0, PHP_ROUND_HALF_UP);
       } 
     if($dias < 100 || $dias==0){ 
        $num++;
        $data[]=array(
        "0"=>$num,
        "1"=>$nombres,
        "2"=>$reg->carnet,
        "3"=>($reg->concepto=='INS')?'<a>INSCRIPCIÓN </a>':'<a title="'.$reg->especialidad.'">'.$reg->codigo.' ('.$reg->version.')</a>',
        "4"=>$reg->cuenta_bancaria,
        "5"=>$reg->codigo_transaccion,
        "6"=>'<center>'.$reg->monto_total.' Bs. </center>',
        "7"=>$fecha,
        "8"=>$reg->estado_t,
        "9"=>$reg->descripcion,
        "10"=>$reg->concepto,
        "11"=>'<center>'.$estadoUso.'<center>',
        "19"=>$estadoTransaccion    
        );
     }
    } 
    $results = array(
      "sEcho"=>1, //Informacion para el datatables
      "iTotalRecords"=>count($data), //enviamos el total registros al datatable
      "iTotalDisplayRecords"=>count($data), //enviamos el total registros a visualizar
      "aaData"=>$data);
    echo json_encode($results);
    exit();
    }else {
       echo'erro en la conexion a la base de datos';
    }
?>